<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\AuditoriaAcceso;
use Illuminate\Http\Request;

class AuditoriaController extends Controller
{
    public function index(Request $request)
    {
        $query = AuditoriaAcceso::with('usuario')
            ->orderBy('created_at', 'desc');

        // Filtros
        if ($request->filled('tipo')) {
            $query->where('tipo', $request->get('tipo'));
        }

        if ($request->filled('usuario_id')) {
            $query->where('usuario_id', $request->get('usuario_id'));
        }

        if ($request->filled('fecha_inicio')) {
            $query->whereDate('created_at', '>=', $request->get('fecha_inicio'));
        }

        if ($request->filled('fecha_fin')) {
            $query->whereDate('created_at', '<=', $request->get('fecha_fin'));
        }

        if ($request->filled('ip_address')) {
            $query->where('ip_address', 'like', '%' . $request->get('ip_address') . '%');
        }

        $accesos = $query->paginate(50)->withQueryString();

        $usuarios = \App\Models\User::orderBy('nombre')->get();

        // Estadísticas
        $estadisticas = [
            'total' => AuditoriaAcceso::count(),
            'login_exitoso' => AuditoriaAcceso::loginExitoso()->count(),
            'login_fallido' => AuditoriaAcceso::loginFallido()->count(),
            'hoy' => AuditoriaAcceso::whereDate('created_at', today())->count(),
        ];

        return view('admin.auditoria.index', [
            'accesos' => $accesos,
            'usuarios' => $usuarios,
            'estadisticas' => $estadisticas,
        ]);
    }
}

