<?php

namespace App\Http\Controllers\Vendedor;

use App\Http\Controllers\Controller;
use App\Models\Cliente;
use App\Models\SolicitudCreacion;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class DashboardController extends Controller
{
    public function index(Request $request)
    {
        $vendedorId = Auth::id();
        $view = $request->get('view', 'todos');

        // Estadísticas del dashboard
        $clientesAsignados = Cliente::deVendedor($vendedorId)->get();
        $totalClientes = $clientesAsignados->count();
        
        $clientesAlerta = 0;
        $clientesSinDocs = 0;
        $clientesVencidos = 0;

        foreach ($clientesAsignados as $cliente) {
            $estatus = $cliente->calcularEstatus();
            if ($estatus['texto'] === 'ALERTA') {
                $clientesAlerta++;
            }
            if ($estatus['texto'] === 'SIN DOCUMENTOS') {
                $clientesSinDocs++;
            }
            if ($estatus['texto'] === 'VENCIDO') {
                $clientesVencidos++;
            }
        }

        // Lista de clientes según la vista
        $listaClientes = [];
        $clientesConAlertaDocs = [];

        if ($view === 'todos' || $view === 'proximos') {
            $listaClientes = Cliente::deVendedor($vendedorId)
                ->with(['documentos.tipoDocumento'])
                ->orderBy('nombre_empresa')
                ->get();

            if ($view === 'proximos') {
                foreach ($listaClientes as $cliente) {
                    $docsAlerta = $cliente->documentos()
                        ->proximosAVencer(6)
                        ->get();
                    if ($docsAlerta->isNotEmpty()) {
                        $clientesConAlertaDocs[$cliente->id] = $docsAlerta;
                    }
                }
            }
        }

        // Solicitudes de creación
        $solicitudes = SolicitudCreacion::where('vendedor_id', $vendedorId)
            ->orderBy('fecha_solicitud', 'desc')
            ->get();

        return view('vendedor.dashboard', [
            'totalClientes' => $totalClientes,
            'clientesAlerta' => $clientesAlerta,
            'clientesSinDocs' => $clientesSinDocs,
            'clientesVencidos' => $clientesVencidos,
            'listaClientes' => $listaClientes,
            'clientesConAlertaDocs' => $clientesConAlertaDocs,
            'solicitudes' => $solicitudes,
            'view' => $view,
        ]);
    }
}

