<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class CheckVendedor
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        if (!auth()->check()) {
            return redirect()->route('vendedor.login');
        }

        $user = auth()->user();
        
        if (!$user->isVendedor()) {
            abort(403, 'Acceso denegado. Solo vendedores pueden acceder.');
        }

        return $next($request);
    }
}

