<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class AuditoriaAcceso extends Model
{
    use HasFactory;

    protected $table = 'auditoria_accesos';

    public $timestamps = false;

    protected $fillable = [
        'usuario_id',
        'email',
        'ip_address',
        'user_agent',
        'tipo',
        'detalles',
    ];

    protected function casts(): array
    {
        return [
            'created_at' => 'datetime',
        ];
    }

    // Relaciones
    public function usuario(): BelongsTo
    {
        return $this->belongsTo(User::class, 'usuario_id');
    }

    // Scopes
    public function scopeLoginExitoso($query)
    {
        return $query->where('tipo', 'login_exitoso');
    }

    public function scopeLoginFallido($query)
    {
        return $query->where('tipo', 'login_fallido');
    }

    public function scopePorUsuario($query, $usuarioId)
    {
        return $query->where('usuario_id', $usuarioId);
    }

    public function scopePorIP($query, $ip)
    {
        return $query->where('ip_address', $ip);
    }
}

