<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Rol extends Model
{
    use HasFactory;

    protected $table = 'roles';

    protected $fillable = [
        'nombre_rol',
        'descripcion',
        'permisos',
    ];

    protected function casts(): array
    {
        return [
            'permisos' => 'array',
        ];
    }

    // Relaciones
    public function users(): HasMany
    {
        return $this->hasMany(User::class, 'rol_id');
    }

    // Scopes
    public function scopeActivos($query)
    {
        return $query->where('activo', true);
    }
}

