<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class SolicitudCreacion extends Model
{
    use HasFactory;

    protected $table = 'solicitudes_creacion_cliente';

    protected $fillable = [
        'vendedor_id',
        'nombre_empresa',
        'rif',
        'direccion_fiscal',
        'zona',
        'notas',
        'estatus',
        'fecha_solicitud',
        'revisado_por_id',
        'fecha_revision',
        'observaciones',
    ];

    protected function casts(): array
    {
        return [
            'fecha_solicitud' => 'datetime',
            'fecha_revision' => 'datetime',
        ];
    }

    // Relaciones
    public function vendedor(): BelongsTo
    {
        return $this->belongsTo(User::class, 'vendedor_id');
    }

    public function revisadoPor(): BelongsTo
    {
        return $this->belongsTo(User::class, 'revisado_por_id');
    }

    // Scopes
    public function scopePendientes($query)
    {
        return $query->where('estatus', 'Pendiente');
    }

    public function scopeAprobadas($query)
    {
        return $query->where('estatus', 'Aprobada');
    }

    public function scopeRechazadas($query)
    {
        return $query->where('estatus', 'Rechazada');
    }
}

