<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class SolicitudEdicion extends Model
{
    use HasFactory;

    protected $table = 'solicitudes_edicion_cliente';

    protected $fillable = [
        'cliente_id',
        'vendedor_id',
        'cambios',
        'estatus',
        'fecha_solicitud',
        'revisado_por_id',
        'fecha_revision',
        'observaciones',
    ];

    protected function casts(): array
    {
        return [
            'cambios' => 'array',
            'fecha_solicitud' => 'datetime',
            'fecha_revision' => 'datetime',
        ];
    }

    // Relaciones
    public function cliente(): BelongsTo
    {
        return $this->belongsTo(Cliente::class);
    }

    public function vendedor(): BelongsTo
    {
        return $this->belongsTo(User::class, 'vendedor_id');
    }

    public function revisadoPor(): BelongsTo
    {
        return $this->belongsTo(User::class, 'revisado_por_id');
    }

    // Scopes
    public function scopePendientes($query)
    {
        return $query->where('estatus', 'Pendiente');
    }
}

