<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;

class User extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable;

    protected $fillable = [
        'nombre',
        'email',
        'password',
        'rol_id',
        'activo',
    ];

    protected $hidden = [
        'password',
        'remember_token',
    ];

    protected function casts(): array
    {
        return [
            'email_verified_at' => 'datetime',
            'password' => 'hashed',
            'activo' => 'boolean',
        ];
    }

    // Relaciones
    public function rol()
    {
        return $this->belongsTo(Rol::class, 'rol_id');
    }

    public function clientes()
    {
        return $this->hasMany(Cliente::class, 'vendedor_id');
    }

    public function notificaciones()
    {
        return $this->hasMany(Notificacion::class, 'destinatario_id');
    }

    public function pushSubscriptions()
    {
        return $this->hasMany(PushSubscription::class, 'user_id');
    }

    // Scopes
    public function scopeActivos($query)
    {
        return $query->where('activo', true);
    }

    public function scopeVendedores($query)
    {
        return $query->whereHas('rol', function($q) {
            $q->where('nombre_rol', 'Vendedor');
        });
    }

    // Helpers
    public function isAdmin()
    {
        return $this->rol && $this->rol->nombre_rol === 'Administrador';
    }

    public function isVendedor()
    {
        return $this->rol && $this->rol->nombre_rol === 'Vendedor';
    }
}

