<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('users', function (Blueprint $table) {
            $table->id();
            $table->string('nombre');
            $table->string('email')->unique();
            $table->timestamp('email_verified_at')->nullable();
            $table->string('password');
            $table->foreignId('rol_id')->constrained('roles')->onDelete('restrict');
            $table->boolean('activo')->default(true);
            $table->rememberToken();
            $table->timestamps();
            
            $table->index('email');
            $table->index('rol_id');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('users');
    }
};

