<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('configuraciones', function (Blueprint $table) {
            $table->id();
            $table->string('clave')->unique();
            $table->text('valor')->nullable();
            $table->string('tipo')->default('text'); // text, number, boolean, json
            $table->text('descripcion')->nullable();
            $table->string('categoria')->default('general'); // general, documentos, sistema, apariencia
            $table->timestamps();
            
            $table->index('clave');
            $table->index('categoria');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('configuraciones');
    }
};

