<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('auditoria_accesos', function (Blueprint $table) {
            $table->id();
            $table->foreignId('usuario_id')->nullable()->constrained('users')->onDelete('set null');
            $table->string('email')->nullable(); // Para intentos fallidos
            $table->string('ip_address', 45);
            $table->string('user_agent')->nullable();
            $table->enum('tipo', ['login_exitoso', 'login_fallido', 'logout', 'acceso_denegado'])->default('login_exitoso');
            $table->text('detalles')->nullable();
            $table->timestamp('created_at')->useCurrent();
            
            $table->index('usuario_id');
            $table->index('email');
            $table->index('tipo');
            $table->index('created_at');
            $table->index('ip_address');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('auditoria_accesos');
    }
};

