<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\User;
use App\Models\Rol;
use Illuminate\Support\Facades\Hash;

class AdminUserSeeder extends Seeder
{
    public function run(): void
    {
        $adminRol = Rol::where('nombre_rol', 'Administrador')->first();

        if (!$adminRol) {
            $this->command->error('El rol Administrador no existe. Ejecuta RolSeeder primero.');
            return;
        }

        User::updateOrCreate(
            ['email' => 'admin@example.com'],
            [
                'nombre' => 'Administrador',
                'email' => 'admin@example.com',
                'password' => Hash::make('password'), // Cambiar en producción
                'rol_id' => $adminRol->id,
                'activo' => true,
            ]
        );

        $this->command->info('Usuario administrador creado: admin@example.com / password');
    }
}

