<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\User;
use App\Models\Rol;
use Illuminate\Support\Facades\Hash;

class VendedorUserSeeder extends Seeder
{
    public function run(): void
    {
        $vendedorRol = Rol::where('nombre_rol', 'Vendedor')->first();

        if (!$vendedorRol) {
            $this->command->error('El rol Vendedor no existe. Ejecuta RolSeeder primero.');
            return;
        }

        // Crear usuario vendedor de ejemplo
        User::updateOrCreate(
            ['email' => 'vendedor@example.com'],
            [
                'nombre' => 'Vendedor Ejemplo',
                'email' => 'vendedor@example.com',
                'password' => Hash::make('password'), // Cambiar en producción
                'rol_id' => $vendedorRol->id,
                'activo' => true,
            ]
        );

        $this->command->info('Usuario vendedor creado: vendedor@example.com / password');
        $this->command->info('');
        $this->command->warn('⚠️  IMPORTANTE: Cambia la contraseña en producción');
    }
}

