<?php
/**
 * Script de diagnóstico para error 404
 * Visita: http://fmpafia.ddns.net:9191/documentos/diagnostico-404.php
 */

header('Content-Type: text/html; charset=utf-8');
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Diagnóstico Error 404</title>
    <style>
        body { font-family: Arial, sans-serif; max-width: 900px; margin: 50px auto; padding: 20px; }
        .ok { color: green; font-weight: bold; }
        .error { color: red; font-weight: bold; }
        .warning { color: orange; font-weight: bold; }
        pre { background: #f5f5f5; padding: 15px; border-radius: 5px; overflow-x: auto; border-left: 4px solid #333; }
        h2 { border-bottom: 2px solid #333; padding-bottom: 10px; margin-top: 30px; }
        .section { margin: 20px 0; padding: 15px; background: #f9f9f9; border-radius: 5px; }
        code { background: #e8e8e8; padding: 2px 6px; border-radius: 3px; }
    </style>
</head>
<body>
    <h1>🔍 Diagnóstico Error 404 - Laravel en Subdirectorio</h1>
    
    <div class="section">
        <h2>1. Información del Servidor</h2>
        <ul>
            <li><strong>PHP Version:</strong> <?php echo phpversion(); ?></li>
            <li><strong>Document Root:</strong> <code><?php echo $_SERVER['DOCUMENT_ROOT'] ?? 'No disponible'; ?></code></li>
            <li><strong>Script Name:</strong> <code><?php echo $_SERVER['SCRIPT_NAME'] ?? 'No disponible'; ?></code></li>
            <li><strong>Request URI:</strong> <code><?php echo $_SERVER['REQUEST_URI'] ?? 'No disponible'; ?></code></li>
            <li><strong>Base Path:</strong> <code><?php echo dirname($_SERVER['SCRIPT_NAME'] ?? ''); ?></code></li>
            <li><strong>Server Software:</strong> <?php echo $_SERVER['SERVER_SOFTWARE'] ?? 'No disponible'; ?></li>
        </ul>
    </div>
    
    <div class="section">
        <h2>2. Verificación de Archivos Críticos</h2>
        <ul>
            <li>
                <strong>public/.htaccess:</strong> 
                <?php 
                $htaccessExists = file_exists(__DIR__ . '/.htaccess');
                echo $htaccessExists ? '<span class="ok">✓ Existe</span>' : '<span class="error">✗ No existe - CRÍTICO</span>'; 
                ?>
            </li>
            <li>
                <strong>public/index.php:</strong> 
                <?php 
                $indexExists = file_exists(__DIR__ . '/index.php');
                echo $indexExists ? '<span class="ok">✓ Existe</span>' : '<span class="error">✗ No existe - CRÍTICO</span>'; 
                ?>
            </li>
            <li>
                <strong>bootstrap/app.php:</strong> 
                <?php 
                $bootstrapExists = file_exists(__DIR__ . '/../bootstrap/app.php');
                echo $bootstrapExists ? '<span class="ok">✓ Existe</span>' : '<span class="error">✗ No existe - CRÍTICO</span>'; 
                ?>
            </li>
            <li>
                <strong>vendor/autoload.php:</strong> 
                <?php 
                $vendorExists = file_exists(__DIR__ . '/../vendor/autoload.php');
                echo $vendorExists ? '<span class="ok">✓ Existe</span>' : '<span class="warning">⚠ No existe (ejecuta composer install)</span>'; 
                ?>
            </li>
        </ul>
    </div>
    
    <div class="section">
        <h2>3. Verificación de .htaccess</h2>
        <?php
        $htaccessPath = __DIR__ . '/.htaccess';
        if (file_exists($htaccessPath)) {
            $htaccess = file_get_contents($htaccessPath);
            $hasRewriteBase = strpos($htaccess, 'RewriteBase /documentos/') !== false;
            $hasRewriteEngine = strpos($htaccess, 'RewriteEngine On') !== false;
            $hasIndexRule = strpos($htaccess, 'RewriteRule ^ index.php') !== false;
            ?>
            <ul>
                <li>
                    <strong>RewriteEngine On:</strong> 
                    <?php echo $hasRewriteEngine ? '<span class="ok">✓ Configurado</span>' : '<span class="error">✗ No configurado</span>'; ?>
                </li>
                <li>
                    <strong>RewriteBase /documentos/:</strong> 
                    <?php echo $hasRewriteBase ? '<span class="ok">✓ Configurado</span>' : '<span class="warning">⚠ No configurado (necesario para subdirectorio)</span>'; ?>
                </li>
                <li>
                    <strong>RewriteRule a index.php:</strong> 
                    <?php echo $hasIndexRule ? '<span class="ok">✓ Configurado</span>' : '<span class="error">✗ No configurado</span>'; ?>
                </li>
                <li>
                    <strong>mod_rewrite:</strong> 
                    <?php 
                    if (function_exists('apache_get_modules')) {
                        $modules = apache_get_modules();
                        echo in_array('mod_rewrite', $modules) ? '<span class="ok">✓ Habilitado</span>' : '<span class="error">✗ No habilitado - CRÍTICO</span>';
                    } else {
                        echo '<span class="warning">⚠ No se puede verificar (revisa phpinfo)</span>';
                    }
                    ?>
                </li>
            </ul>
            
            <h3>Contenido de .htaccess (primeras 30 líneas):</h3>
            <pre><?php echo htmlspecialchars(substr($htaccess, 0, 1500)); ?></pre>
            <?php
        } else {
            echo '<p class="error">✗ El archivo .htaccess NO existe. Esto es CRÍTICO.</p>';
        }
        ?>
    </div>
    
    <div class="section">
        <h2>4. Diagnóstico del Problema</h2>
        <?php
        $problems = [];
        $solutions = [];
        
        if (!file_exists($htaccessPath)) {
            $problems[] = "El archivo .htaccess no existe";
            $solutions[] = "Crea el archivo public/.htaccess con la configuración de Laravel";
        }
        
        if (function_exists('apache_get_modules')) {
            $modules = apache_get_modules();
            if (!in_array('mod_rewrite', $modules)) {
                $problems[] = "mod_rewrite no está habilitado";
                $solutions[] = "Habilita mod_rewrite en httpd.conf: LoadModule rewrite_module modules/mod_rewrite.so";
            }
        }
        
        if (file_exists($htaccessPath)) {
            $htaccess = file_get_contents($htaccessPath);
            if (strpos($htaccess, 'RewriteBase /documentos/') === false) {
                $problems[] = "RewriteBase /documentos/ no está configurado";
                $solutions[] = "Agrega 'RewriteBase /documentos/' después de 'RewriteEngine On' en public/.htaccess";
            }
        }
        
        if (empty($problems)) {
            echo '<p class="ok">✓ No se detectaron problemas obvios en la configuración de archivos.</p>';
            echo '<p><strong>El problema probablemente está en la configuración de Apache:</strong></p>';
            echo '<ol>';
            echo '<li>Verifica que Apache tenga configurado el Alias: <code>Alias /documentos "C:/laragon/www/DOCUMENTOS/public"</code></li>';
            echo '<li>Verifica que el Directory tenga <code>AllowOverride All</code></li>';
            echo '<li>Verifica que el puerto 9191 esté escuchando: <code>Listen 9191</code></li>';
            echo '<li>Reinicia Apache después de hacer cambios</li>';
            echo '</ol>';
        } else {
            echo '<h3>Problemas Detectados:</h3>';
            echo '<ul>';
            foreach ($problems as $problem) {
                echo '<li class="error">✗ ' . htmlspecialchars($problem) . '</li>';
            }
            echo '</ul>';
            
            echo '<h3>Soluciones:</h3>';
            echo '<ol>';
            foreach ($solutions as $solution) {
                echo '<li>' . htmlspecialchars($solution) . '</li>';
            }
            echo '</ol>';
        }
        ?>
    </div>
    
    <div class="section">
        <h2>5. Configuración Recomendada de Apache</h2>
        <p>Para Laragon, agrega esto al final de <code>httpd.conf</code>:</p>
        <pre># Configuración para /documentos/ en puerto 9191
Listen 9191

Alias /documentos "C:/laragon/www/DOCUMENTOS/public"

&lt;Directory "C:/laragon/www/DOCUMENTOS/public"&gt;
    Options Indexes FollowSymLinks
    AllowOverride All
    Require all granted
    RewriteEngine On
&lt;/Directory&gt;</pre>
        
        <p><strong>IMPORTANTE:</strong> Después de modificar httpd.conf, reinicia Apache en Laragon.</p>
    </div>
    
    <div class="section">
        <h2>6. Pruebas Rápidas</h2>
        <p>Prueba estas URLs en orden:</p>
        <ol>
            <li><a href="/documentos/diagnostico-404.php">/documentos/diagnostico-404.php</a> (esta página)</li>
            <li><a href="/documentos/index.php">/documentos/index.php</a> (debe funcionar)</li>
            <li><a href="/documentos/">/documentos/</a> (debe redirigir o mostrar login)</li>
            <li><a href="/documentos/login">/documentos/login</a> (debe mostrar formulario de login)</li>
        </ol>
    </div>
    
    <hr>
    <p><small><strong>Nota:</strong> Elimina este archivo después de diagnosticar el problema por seguridad.</small></p>
</body>
</html>

