<?php
/**
 * Script de prueba para verificar que Apache está sirviendo correctamente
 */

echo "<h1>Prueba de Apache - Funciona!</h1>";
echo "<p><strong>PHP Version:</strong> " . phpversion() . "</p>";
echo "<p><strong>Document Root:</strong> " . $_SERVER['DOCUMENT_ROOT'] . "</p>";
echo "<p><strong>Script Name:</strong> " . $_SERVER['SCRIPT_NAME'] . "</p>";
echo "<p><strong>Request URI:</strong> " . $_SERVER['REQUEST_URI'] . "</p>";
echo "<p><strong>Server Name:</strong> " . $_SERVER['SERVER_NAME'] . "</p>";
echo "<p><strong>Server Port:</strong> " . $_SERVER['SERVER_PORT'] . "</p>";

// Verificar si index.php existe
$indexPath = __DIR__ . '/index.php';
echo "<hr>";
echo "<h2>Verificación de Archivos</h2>";
echo "<p><strong>index.php existe:</strong> " . (file_exists($indexPath) ? 'SÍ ✅' : 'NO ❌') . "</p>";
echo "<p><strong>Ruta completa:</strong> " . $indexPath . "</p>";

// Verificar .htaccess
$htaccessPath = __DIR__ . '/.htaccess';
echo "<p><strong>.htaccess existe:</strong> " . (file_exists($htaccessPath) ? 'SÍ ✅' : 'NO ❌') . "</p>";

// Probar acceso a index.php
echo "<hr>";
echo "<h2>Pruebas de Acceso</h2>";
echo "<p><a href='/documentos/'>Ir a /documentos/</a></p>";
echo "<p><a href='/documentos/index.php'>Ir a /documentos/index.php</a></p>";
echo "<p><a href='/documentos/login'>Ir a /documentos/login</a></p>";
echo "<p><a href='/documentos/test-apache.php'>Recargar esta página</a></p>";

