<?php
/**
 * Prueba directa de la ruta de login
 * Accede a: http://fmpafia.ddns.net:9191/documentos/test-login-direct.php
 */

require __DIR__ . '/../vendor/autoload.php';

$app = require_once __DIR__ . '/../bootstrap/app.php';

echo "<h1>🔍 Prueba Directa de Login</h1>";

// Simular una petición GET a /login
$request = \Illuminate\Http\Request::create('/login', 'GET');
$response = $app->handle($request);

echo "<h2>Resultado:</h2>";
echo "<p><strong>Status Code:</strong> " . $response->getStatusCode() . "</p>";
echo "<p><strong>Content Type:</strong> " . $response->headers->get('Content-Type') . "</p>";

if ($response->getStatusCode() === 200) {
    echo "<p>✅ La ruta /login funciona correctamente</p>";
    echo "<h3>Contenido:</h3>";
    echo "<div style='border: 1px solid #ccc; padding: 10px; max-height: 400px; overflow: auto;'>";
    echo $response->getContent();
    echo "</div>";
} else {
    echo "<p>❌ La ruta /login devolvió un error</p>";
}

echo "<hr>";
echo "<h2>Prueba de URL Real:</h2>";
echo "<p>Ahora prueba acceder directamente a:</p>";
echo "<ul>";
echo "<li><a href='/documentos/login' target='_blank'>/documentos/login</a></li>";
echo "<li><a href='/documentos/index.php' target='_blank'>/documentos/index.php</a></li>";
echo "</ul>";

echo "<hr>";
echo "<p><small>Elimina este archivo después de verificar por seguridad.</small></p>";

