<?php
/**
 * Script de verificación de configuración para subdirectorio
 * Visita: http://tu-dominio.com/documentos/verificar-configuracion.php
 */

header('Content-Type: text/html; charset=utf-8');
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Verificación de Configuración</title>
    <style>
        body { font-family: Arial, sans-serif; max-width: 800px; margin: 50px auto; padding: 20px; }
        .ok { color: green; }
        .error { color: red; }
        .warning { color: orange; }
        pre { background: #f5f5f5; padding: 10px; border-radius: 5px; overflow-x: auto; }
        h2 { border-bottom: 2px solid #333; padding-bottom: 10px; }
    </style>
</head>
<body>
    <h1>🔍 Verificación de Configuración Laravel</h1>
    
    <h2>1. Información del Servidor</h2>
    <ul>
        <li><strong>PHP Version:</strong> <?php echo phpversion(); ?></li>
        <li><strong>Document Root:</strong> <?php echo $_SERVER['DOCUMENT_ROOT']; ?></li>
        <li><strong>Script Name:</strong> <?php echo $_SERVER['SCRIPT_NAME']; ?></li>
        <li><strong>Request URI:</strong> <?php echo $_SERVER['REQUEST_URI']; ?></li>
        <li><strong>Base Path:</strong> <?php echo dirname($_SERVER['SCRIPT_NAME']); ?></li>
    </ul>
    
    <h2>2. Verificación de Archivos</h2>
    <ul>
        <li>
            <strong>public/.htaccess:</strong> 
            <?php echo file_exists(__DIR__ . '/.htaccess') ? '<span class="ok">✓ Existe</span>' : '<span class="error">✗ No existe</span>'; ?>
        </li>
        <li>
            <strong>public/index.php:</strong> 
            <?php echo file_exists(__DIR__ . '/index.php') ? '<span class="ok">✓ Existe</span>' : '<span class="error">✗ No existe</span>'; ?>
        </li>
        <li>
            <strong>bootstrap/app.php:</strong> 
            <?php echo file_exists(__DIR__ . '/../bootstrap/app.php') ? '<span class="ok">✓ Existe</span>' : '<span class="error">✗ No existe</span>'; ?>
        </li>
        <li>
            <strong>.env:</strong> 
            <?php echo file_exists(__DIR__ . '/../.env') ? '<span class="ok">✓ Existe</span>' : '<span class="warning">⚠ No existe (usa .env.example)</span>'; ?>
        </li>
    </ul>
    
    <h2>3. Verificación de .htaccess</h2>
    <?php
    $htaccess = file_get_contents(__DIR__ . '/.htaccess');
    $hasRewriteBase = strpos($htaccess, 'RewriteBase /documentos/') !== false;
    ?>
    <ul>
        <li>
            <strong>RewriteBase /documentos/:</strong> 
            <?php echo $hasRewriteBase ? '<span class="ok">✓ Configurado</span>' : '<span class="warning">⚠ No configurado (necesario para subdirectorio)</span>'; ?>
        </li>
        <li>
            <strong>mod_rewrite:</strong> 
            <?php 
            if (function_exists('apache_get_modules')) {
                $modules = apache_get_modules();
                echo in_array('mod_rewrite', $modules) ? '<span class="ok">✓ Habilitado</span>' : '<span class="error">✗ No habilitado</span>';
            } else {
                echo '<span class="warning">⚠ No se puede verificar (revisa phpinfo)</span>';
            }
            ?>
        </li>
    </ul>
    
    <h2>4. Configuración Recomendada</h2>
    <p>Para que funcione correctamente en <code>/documentos/</code>:</p>
    <ol>
        <li>En <code>public/.htaccess</code>, asegúrate de que tenga: <code>RewriteBase /documentos/</code></li>
        <li>En <code>.env</code>, configura: <code>APP_URL=http://fmpafia.ddns.net:9191/documentos</code></li>
        <li>En Apache, configura un Alias o DocumentRoot apuntando a <code>/ruta/DOCUMENTOS/public</code></li>
    </ol>
    
    <h2>5. Próximos Pasos</h2>
    <p>Si todo está correcto, visita: <a href="/documentos/">/documentos/</a></p>
    <p>Deberías ver la página de login de Laravel.</p>
    
    <hr>
    <p><small>Elimina este archivo después de verificar la configuración por seguridad.</small></p>
</body>
</html>

