@extends('layouts.app')

@section('title', 'Backup y Restauración')

@section('content')
<div class="page-header">
    <h1 class="page-title">
        <i class="fas fa-database"></i> Backup y Restauración
    </h1>
    <div class="header-actions">
        <form action="{{ route('admin.backup.crear') }}" method="POST" class="inline-form">
            @csrf
            <button type="submit" class="btn btn-primary">
                <i class="fas fa-plus"></i> Crear Backup
            </button>
        </form>
    </div>
</div>

<div class="alert alert-info">
    <i class="fas fa-info-circle"></i> 
    <strong>Nota:</strong> Los backups se guardan en <code>storage/app/backups/</code>. 
    Asegúrate de hacer copias de seguridad periódicas y almacenarlas en un lugar seguro.
</div>

<div class="card">
    <div class="card-header">
        <h3><i class="fas fa-history"></i> Backups Disponibles</h3>
    </div>
    <div class="card-body">
        @if(count($backups) > 0)
        <div class="table-container">
            <table class="data-table">
                <thead>
                    <tr>
                        <th>Nombre del Archivo</th>
                        <th>Tamaño</th>
                        <th>Fecha de Creación</th>
                        <th>Acciones</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($backups as $backup)
                    <tr>
                        <td>
                            <i class="fas fa-file-archive"></i> 
                            <code>{{ $backup['nombre'] }}</code>
                        </td>
                        <td>{{ $backup['tamaño'] }}</td>
                        <td>{{ $backup['fecha'] }}</td>
                        <td class="actions">
                            <a href="{{ route('admin.backup.descargar', $backup['nombre']) }}" 
                               class="btn btn-sm btn-success btn-icon" 
                               title="Descargar backup">
                                <i class="fas fa-download"></i>
                            </a>
                            <form action="{{ route('admin.backup.eliminar', $backup['nombre']) }}" 
                                  method="POST" 
                                  class="inline-form delete-form"
                                  style="display: inline;">
                                @csrf
                                @method('DELETE')
                                <button type="submit" 
                                        class="btn btn-sm btn-danger btn-icon" 
                                        title="Eliminar backup">
                                    <i class="fas fa-trash-alt"></i>
                                </button>
                            </form>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
        @else
        <div class="alert alert-warning">
            <i class="fas fa-exclamation-triangle"></i> 
            No hay backups disponibles. Crea tu primer backup para comenzar.
        </div>
        @endif
    </div>
</div>

<div class="card" style="margin-top: 2rem;">
    <div class="card-header">
        <h3><i class="fas fa-info-circle"></i> Información</h3>
    </div>
    <div class="card-body">
        <ul style="line-height: 2;">
            <li><strong>Recomendación:</strong> Crea backups diarios o semanales según la frecuencia de cambios.</li>
            <li><strong>Almacenamiento:</strong> Descarga los backups y guárdalos en un lugar seguro fuera del servidor.</li>
            <li><strong>Restauración:</strong> Para restaurar un backup, usa el comando MySQL: <code>mysql -u usuario -p nombre_base_datos < backup.sql</code></li>
            <li><strong>Requisitos:</strong> Se requiere que <code>mysqldump</code> esté instalado y accesible desde la línea de comandos.</li>
        </ul>
    </div>
</div>
@endsection

