@extends('layouts.app')

@section('title', 'Editar Cliente')

@section('content')
<div class="page-header">
    <h1 class="page-title">Editar Cliente: {{ $cliente->nombre_empresa }}</h1>
    <a href="{{ route('admin.clientes.index') }}" class="btn btn-secondary">
        <i class="fas fa-arrow-left"></i> Volver
    </a>
</div>

<form action="{{ route('admin.clientes.update', $cliente->id) }}" method="POST" class="form-container">
    @csrf @method('PUT')
    
    <div class="form-group">
        <label for="nombre_empresa">Nombre de la Empresa *</label>
        <input type="text" name="nombre_empresa" id="nombre_empresa" 
               class="form-control" value="{{ old('nombre_empresa', $cliente->nombre_empresa) }}" required>
    </div>
    
    <div class="form-group">
        <label for="rif">RIF *</label>
        <input type="text" name="rif" id="rif" 
               class="form-control" value="{{ old('rif', $cliente->rif) }}" required>
    </div>
    
    <div class="form-group">
        <label for="direccion_fiscal">Dirección Fiscal</label>
        <textarea name="direccion_fiscal" id="direccion_fiscal" 
                  class="form-control" rows="3">{{ old('direccion_fiscal', $cliente->direccion_fiscal) }}</textarea>
    </div>
    
    <div class="form-group">
        <label for="zona">Zona</label>
        <input type="text" name="zona" id="zona" 
               class="form-control" value="{{ old('zona', $cliente->zona) }}">
    </div>
    
    <div class="form-group">
        <label for="vendedor_id">Vendedor Asignado</label>
        <select name="vendedor_id" id="vendedor_id" class="form-control">
            <option value="">Sin asignar</option>
            @foreach($vendedores as $vendedor)
                <option value="{{ $vendedor->id }}" 
                        {{ old('vendedor_id', $cliente->vendedor_id) == $vendedor->id ? 'selected' : '' }}>
                    {{ $vendedor->nombre }}
                </option>
            @endforeach
        </select>
    </div>
    
    <div class="form-group">
        <label for="notas">Notas</label>
        <textarea name="notas" id="notas" 
                  class="form-control" rows="3">{{ old('notas', $cliente->notas) }}</textarea>
    </div>
    
    <div class="form-actions">
        <button type="submit" class="btn btn-primary">
            <i class="fas fa-save"></i> Actualizar Cliente
        </button>
        <a href="{{ route('admin.clientes.index') }}" class="btn btn-secondary">Cancelar</a>
    </div>
</form>
@endsection

