@extends('layouts.app')

@section('title', 'Clientes')

@section('content')
<div class="page-header">
    <h1 class="page-title">Gestión de Clientes</h1>
    <div class="header-actions">
        <a href="{{ route('admin.clientes.create') }}" class="btn btn-primary">
            <i class="fas fa-plus"></i> Nuevo Cliente
        </a>
        <a href="{{ route('admin.exportar.clientes', request()->all()) }}" class="btn btn-success">
            <i class="fas fa-file-excel"></i> Exportar CSV
        </a>
    </div>
</div>

<!-- Formulario de Búsqueda y Filtros -->
<div class="card" style="margin-bottom: 2rem;">
    <div class="card-header">
        <h3><i class="fas fa-search"></i> Búsqueda y Filtros</h3>
    </div>
    <div class="card-body">
        <form method="GET" action="{{ route('admin.clientes.index') }}" class="filters-form">
            <div class="filters-grid">
                <div class="form-group">
                    <label class="form-label" for="buscar">
                        <i class="fas fa-search"></i> Buscar
                    </label>
                    <input type="text" name="buscar" id="buscar" class="form-control" 
                           value="{{ request('buscar') }}" 
                           placeholder="Nombre de empresa o RIF">
                </div>

                <div class="form-group">
                    <label class="form-label" for="vendedor_id">
                        <i class="fas fa-user"></i> Vendedor
                    </label>
                    <select name="vendedor_id" id="vendedor_id" class="form-select">
                        <option value="">Todos los vendedores</option>
                        @foreach($vendedores as $vendedor)
                            <option value="{{ $vendedor->id }}" {{ request('vendedor_id') == $vendedor->id ? 'selected' : '' }}>
                                {{ $vendedor->nombre }}
                            </option>
                        @endforeach
                    </select>
                </div>

                <div class="form-group">
                    <label class="form-label" for="zona">
                        <i class="fas fa-map-marker-alt"></i> Zona
                    </label>
                    <select name="zona" id="zona" class="form-select">
                        <option value="">Todas las zonas</option>
                        @foreach($zonas as $zona)
                            <option value="{{ $zona }}" {{ request('zona') == $zona ? 'selected' : '' }}>
                                {{ $zona }}
                            </option>
                        @endforeach
                    </select>
                </div>

                <div class="form-group">
                    <label class="form-label" for="estatus">
                        <i class="fas fa-info-circle"></i> Estatus
                    </label>
                    <select name="estatus" id="estatus" class="form-select">
                        <option value="">Todos los estatus</option>
                        <option value="VENCIDO" {{ request('estatus') == 'VENCIDO' ? 'selected' : '' }}>Vencido</option>
                        <option value="ALERTA" {{ request('estatus') == 'ALERTA' ? 'selected' : '' }}>Alerta</option>
                        <option value="SIN DOCUMENTOS" {{ request('estatus') == 'SIN DOCUMENTOS' ? 'selected' : '' }}>Sin Documentos</option>
                        <option value="ACTUALIZADO" {{ request('estatus') == 'ACTUALIZADO' ? 'selected' : '' }}>Actualizado</option>
                    </select>
                </div>

                <div class="form-group">
                    <label class="form-label" for="orden">
                        <i class="fas fa-sort"></i> Ordenar por
                    </label>
                    <select name="orden" id="orden" class="form-select">
                        <option value="nombre_empresa" {{ request('orden') == 'nombre_empresa' ? 'selected' : '' }}>Nombre</option>
                        <option value="rif" {{ request('orden') == 'rif' ? 'selected' : '' }}>RIF</option>
                        <option value="created_at" {{ request('orden') == 'created_at' ? 'selected' : '' }}>Fecha de creación</option>
                        <option value="estatus" {{ request('orden') == 'estatus' ? 'selected' : '' }}>Estatus</option>
                    </select>
                </div>

                <div class="form-group">
                    <label class="form-label" for="direccion">
                        <i class="fas fa-arrow-up"></i> Dirección
                    </label>
                    <select name="direccion" id="direccion" class="form-select">
                        <option value="asc" {{ request('direccion') == 'asc' ? 'selected' : '' }}>Ascendente</option>
                        <option value="desc" {{ request('direccion') == 'desc' ? 'selected' : '' }}>Descendente</option>
                    </select>
                </div>

                <div class="form-group">
                    <label class="form-label" for="per_page">
                        <i class="fas fa-list"></i> Por página
                    </label>
                    <select name="per_page" id="per_page" class="form-select">
                        <option value="10" {{ request('per_page') == '10' ? 'selected' : '' }}>10</option>
                        <option value="20" {{ request('per_page') == '20' ? 'selected' : '' }}>20</option>
                        <option value="50" {{ request('per_page') == '50' ? 'selected' : '' }}>50</option>
                        <option value="100" {{ request('per_page') == '100' ? 'selected' : '' }}>100</option>
                    </select>
                </div>
            </div>

            <div class="filters-actions">
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-filter"></i> Aplicar Filtros
                </button>
                <a href="{{ route('admin.clientes.index') }}" class="btn btn-secondary">
                    <i class="fas fa-times"></i> Limpiar
                </a>
            </div>
        </form>
    </div>
</div>

@if(request()->hasAny(['buscar', 'vendedor_id', 'zona', 'estatus']))
<div class="alert alert-info">
    <i class="fas fa-info-circle"></i> 
    Mostrando resultados filtrados. 
    <a href="{{ route('admin.clientes.index') }}" class="alert-link">Ver todos los clientes</a>
</div>
@endif

<div class="table-container">
    <table class="data-table">
        <thead>
            <tr>
                <th>Nombre Empresa</th>
                <th>RIF</th>
                <th>Vendedor</th>
                <th>Zona</th>
                <th>Estatus</th>
                <th>Acciones</th>
            </tr>
        </thead>
        <tbody>
            @forelse($clientes as $cliente)
                @php $estatus = $cliente->calcularEstatus(); @endphp
                <tr>
                    <td>{{ $cliente->nombre_empresa }}</td>
                    <td>{{ $cliente->rif }}</td>
                    <td>{{ $cliente->vendedor ? $cliente->vendedor->nombre : 'Sin asignar' }}</td>
                    <td>{{ $cliente->zona ?? '-' }}</td>
                    <td>
                        <span class="badge status-{{ $estatus['clase'] }}">
                            <i class="{{ $estatus['icono'] }}"></i> {{ $estatus['texto'] }}
                        </span>
                    </td>
                    <td class="actions">
                        <a href="{{ route('admin.clientes.show', $cliente->id) }}" class="btn btn-sm btn-info btn-icon" title="Ver detalles">
                            <i class="fas fa-eye"></i>
                        </a>
                        <a href="{{ route('admin.clientes.edit', $cliente->id) }}" class="btn btn-sm btn-warning btn-icon" title="Editar">
                            <i class="fas fa-edit"></i>
                        </a>
                        <form action="{{ route('admin.clientes.destroy', $cliente->id) }}" 
                              method="POST" class="inline-form delete-form">
                            @csrf @method('DELETE')
                            <button type="submit" class="btn btn-sm btn-danger btn-icon" title="Eliminar" data-tooltip="Eliminar cliente">
                                <i class="fas fa-trash-alt"></i>
                            </button>
                        </form>
                    </td>
                </tr>
            @empty
                <tr>
                    <td colspan="6" class="text-center">
                        <i class="fas fa-inbox"></i> No se encontraron clientes con los filtros aplicados.
                    </td>
                </tr>
            @endforelse
        </tbody>
    </table>
    {{ $clientes->links() }}
</div>

@push('styles')
<style>
.filters-form {
    margin: 0;
}

.filters-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
    gap: 1rem;
    margin-bottom: 1rem;
}

.filters-actions {
    display: flex;
    gap: 1rem;
    margin-top: 1rem;
    padding-top: 1rem;
    border-top: 1px solid var(--border-color);
}

.filters-actions .btn {
    min-width: 150px;
}

@media (max-width: 768px) {
    .filters-grid {
        grid-template-columns: 1fr;
    }
    
    .filters-actions {
        flex-direction: column;
    }
    
    .filters-actions .btn {
        width: 100%;
    }
}
</style>
@endpush
@endsection
