@extends('layouts.app')

@section('title', 'Dashboard - Administrador')

@section('content')
<div class="dashboard-container">
    <div class="page-header">
        <h1 class="page-title">Dashboard</h1>
        <div class="header-actions">
            <a href="{{ route('admin.exportar.documentos-vencidos') }}" class="btn btn-danger">
                <i class="fas fa-file-excel"></i> Exportar Vencidos
            </a>
            <a href="{{ route('admin.exportar.documentos-proximos') }}" class="btn btn-warning">
                <i class="fas fa-file-excel"></i> Exportar Próximos
            </a>
        </div>
    </div>
    
    <!-- Estadísticas Principales -->
    <div class="stats-grid">
        <div class="stat-card">
            <div class="stat-icon">
                <i class="fas fa-users"></i>
            </div>
            <div class="stat-content">
                <h3>Total de Clientes</h3>
                <p class="stat-number">{{ $totalClientes }}</p>
            </div>
        </div>
        <div class="stat-card stat-warning">
            <div class="stat-icon">
                <i class="fas fa-exclamation-triangle"></i>
            </div>
            <div class="stat-content">
                <h3>Clientes con Problemas</h3>
                <p class="stat-number">{{ $clientesConProblemas }}</p>
            </div>
        </div>
        <div class="stat-card stat-danger">
            <div class="stat-icon">
                <i class="fas fa-times-circle"></i>
            </div>
            <div class="stat-content">
                <h3>Documentos Vencidos</h3>
                <p class="stat-number">{{ $documentosVencidos }}</p>
            </div>
        </div>
        <div class="stat-card stat-info">
            <div class="stat-icon">
                <i class="fas fa-clock"></i>
            </div>
            <div class="stat-content">
                <h3>Próximos a Vencer</h3>
                <p class="stat-number">{{ $documentosProximos }}</p>
            </div>
        </div>
    </div>

    <!-- Gráficos -->
    <div class="charts-grid">
        <!-- Gráfico de Clientes por Estatus -->
        <div class="chart-card">
            <div class="chart-header">
                <h3><i class="fas fa-chart-pie"></i> Clientes por Estatus</h3>
            </div>
            <div class="chart-body">
                <canvas id="chartEstatus"></canvas>
            </div>
        </div>

        <!-- Gráfico de Documentos Vencidos vs Próximos -->
        <div class="chart-card">
            <div class="chart-header">
                <h3><i class="fas fa-chart-bar"></i> Documentos por Estado</h3>
            </div>
            <div class="chart-body">
                <canvas id="chartDocumentos"></canvas>
            </div>
        </div>

        <!-- Gráfico de Clientes por Vendedor -->
        <div class="chart-card chart-full">
            <div class="chart-header">
                <h3><i class="fas fa-chart-line"></i> Clientes por Vendedor</h3>
            </div>
            <div class="chart-body">
                <canvas id="chartVendedores"></canvas>
            </div>
        </div>
    </div>

    <!-- Actividades Recientes -->
    @if($actividadesRecientes->isNotEmpty())
    <div class="section">
        <h2 class="section-title">
            <i class="fas fa-history"></i> Actividades Recientes
        </h2>
        <div class="activities-list">
            @foreach($actividadesRecientes as $actividad)
            <div class="activity-item">
                <div class="activity-icon">
                    <i class="fas fa-user-circle"></i>
                </div>
                <div class="activity-content">
                    <div class="activity-header">
                        <strong>{{ $actividad->usuario->nombre }}</strong>
                        <span class="activity-time">{{ $actividad->created_at->diffForHumans() }}</span>
                    </div>
                    <div class="activity-action">
                        {{ $actividad->accion_realizada }}
                    </div>
                    <div class="activity-client">
                        Cliente: <strong>{{ $actividad->cliente->nombre_empresa }}</strong>
                    </div>
                </div>
            </div>
            @endforeach
        </div>
    </div>
    @endif

    @if(count($listaVencidos) > 0)
    <div class="section">
        <h2 class="section-title">
            <i class="fas fa-exclamation-circle"></i> Clientes con Documentos Vencidos
        </h2>
        <div class="clientes-list">
            @foreach($listaVencidos as $item)
            <div class="cliente-card card-danger">
                <h4>{{ $item['cliente']->nombre_empresa }}</h4>
                <p>RIF: {{ $item['cliente']->rif }}</p>
                <ul class="documentos-list">
                    @foreach($item['documentos'] as $doc)
                    <li>
                        <i class="fas fa-file-alt"></i>
                        {{ $doc->tipoDocumento->nombre }} 
                        (Vence: {{ $doc->fecha_vencimiento->format('d/m/Y') }})
                    </li>
                    @endforeach
                </ul>
                <a href="{{ route('admin.clientes.show', $item['cliente']->id) }}" class="btn btn-primary">
                    Ver Cliente
                </a>
            </div>
            @endforeach
        </div>
    </div>
    @endif

    @if(count($listaAlerta) > 0)
    <div class="section">
        <h2 class="section-title">
            <i class="fas fa-exclamation-triangle"></i> Clientes con Documentos Próximos a Vencer
        </h2>
        <div class="clientes-list">
            @foreach($listaAlerta as $item)
            <div class="cliente-card card-warning">
                <h4>{{ $item['cliente']->nombre_empresa }}</h4>
                <p>RIF: {{ $item['cliente']->rif }}</p>
                <ul class="documentos-list">
                    @foreach($item['documentos'] as $doc)
                    <li>
                        <i class="fas fa-exclamation-triangle"></i>
                        {{ $doc->tipoDocumento->nombre }} 
                        (Vence: {{ $doc->fecha_vencimiento->format('d/m/Y') }})
                    </li>
                    @endforeach
                </ul>
                <a href="{{ route('admin.clientes.show', $item['cliente']->id) }}" class="btn btn-primary">
                    Ver Cliente
                </a>
            </div>
            @endforeach
        </div>
    </div>
    @endif
</div>

@push('styles')
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/chart.js@4.4.0/dist/chart.min.css">
<style>
.charts-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(400px, 1fr));
    gap: 2rem;
    margin: 2rem 0;
}

.chart-card {
    background: var(--white);
    border-radius: 12px;
    box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
    overflow: hidden;
}

.chart-card.chart-full {
    grid-column: 1 / -1;
}

.chart-header {
    padding: 1.5rem;
    background: linear-gradient(135deg, var(--primary-color) 0%, #0056b3 100%);
    color: var(--white);
}

.chart-header h3 {
    margin: 0;
    display: flex;
    align-items: center;
    gap: 0.5rem;
    font-size: 1.1rem;
}

.chart-body {
    padding: 1.5rem;
    min-height: 300px;
    display: flex;
    align-items: center;
    justify-content: center;
}

.stat-icon {
    width: 60px;
    height: 60px;
    background: rgba(255, 255, 255, 0.2);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 1.5rem;
    margin-right: 1rem;
}

.stat-card {
    display: flex;
    align-items: center;
    padding: 1.5rem;
}

.stat-content h3 {
    margin: 0 0 0.5rem;
    font-size: 0.9rem;
    opacity: 0.9;
}

.activities-list {
    display: flex;
    flex-direction: column;
    gap: 1rem;
}

.activity-item {
    display: flex;
    gap: 1rem;
    padding: 1rem;
    background: var(--white);
    border-radius: 8px;
    box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
    transition: transform 0.2s, box-shadow 0.2s;
}

.activity-item:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 8px rgba(0, 0, 0, 0.15);
}

.activity-icon {
    width: 40px;
    height: 40px;
    background: var(--light-color);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    color: var(--primary-color);
    font-size: 1.2rem;
    flex-shrink: 0;
}

.activity-content {
    flex: 1;
}

.activity-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 0.5rem;
}

.activity-time {
    color: var(--secondary-color);
    font-size: 0.85rem;
}

.activity-action {
    color: var(--dark-color);
    margin-bottom: 0.25rem;
}

.activity-client {
    color: var(--secondary-color);
    font-size: 0.9rem;
}

@media (max-width: 768px) {
    .charts-grid {
        grid-template-columns: 1fr;
    }
}
</style>
@endpush

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js@4.4.0/dist/chart.umd.min.js"></script>
<script>
// Gráfico de Clientes por Estatus
const ctxEstatus = document.getElementById('chartEstatus');
if (ctxEstatus) {
    new Chart(ctxEstatus, {
        type: 'doughnut',
        data: {
            labels: ['Vencido', 'Alerta', 'Sin Documentos', 'Actualizado'],
            datasets: [{
                data: [
                    {{ $clientesPorEstatus['VENCIDO'] }},
                    {{ $clientesPorEstatus['ALERTA'] }},
                    {{ $clientesPorEstatus['SIN DOCUMENTOS'] }},
                    {{ $clientesPorEstatus['ACTUALIZADO'] }}
                ],
                backgroundColor: [
                    '#dc3545',
                    '#ffc107',
                    '#6c757d',
                    '#198754'
                ],
                borderWidth: 2,
                borderColor: '#fff'
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: true,
            plugins: {
                legend: {
                    position: 'bottom'
                }
            }
        }
    });
}

// Gráfico de Documentos
const ctxDocumentos = document.getElementById('chartDocumentos');
if (ctxDocumentos) {
    new Chart(ctxDocumentos, {
        type: 'bar',
        data: {
            labels: ['Vencidos', 'Próximos a Vencer'],
            datasets: [{
                label: 'Cantidad',
                data: [{{ $documentosVencidos }}, {{ $documentosProximos }}],
                backgroundColor: ['#dc3545', '#ffc107'],
                borderColor: ['#c82333', '#e0a800'],
                borderWidth: 2
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: true,
            plugins: {
                legend: {
                    display: false
                }
            },
            scales: {
                y: {
                    beginAtZero: true
                }
            }
        }
    });
}

// Gráfico de Clientes por Vendedor
const ctxVendedores = document.getElementById('chartVendedores');
if (ctxVendedores) {
    const vendedores = @json($clientesPorVendedor->pluck('nombre'));
    const clientes = @json($clientesPorVendedor->pluck('clientes_count'));
    
    new Chart(ctxVendedores, {
        type: 'line',
        data: {
            labels: vendedores,
            datasets: [{
                label: 'Clientes',
                data: clientes,
                borderColor: '#0d6efd',
                backgroundColor: 'rgba(13, 110, 253, 0.1)',
                tension: 0.4,
                fill: true
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: true,
            plugins: {
                legend: {
                    display: false
                }
            },
            scales: {
                y: {
                    beginAtZero: true
                }
            }
        }
    });
}
</script>
@endpush
@endsection
