@extends('layouts.app')

@section('title', 'Reporte: Clientes Sin Documentos')

@section('content')
<div class="page-header">
    <h1 class="page-title">
        <i class="fas fa-file-slash"></i> Clientes Sin Documentos
    </h1>
    <div class="header-actions">
        <a href="{{ route('admin.reportes.index') }}" class="btn btn-secondary">
            <i class="fas fa-arrow-left"></i> Volver
        </a>
    </div>
</div>

<div class="alert alert-warning">
    <i class="fas fa-exclamation-triangle"></i> 
    Total de clientes sin documentos: <strong>{{ $total }}</strong>
</div>

<div class="table-container">
    <table class="data-table">
        <thead>
            <tr>
                <th>Nombre Empresa</th>
                <th>RIF</th>
                <th>Dirección Fiscal</th>
                <th>Zona</th>
                <th>Vendedor</th>
                <th>Fecha Creación</th>
                <th>Acciones</th>
            </tr>
        </thead>
        <tbody>
            @forelse($clientes as $cliente)
                <tr>
                    <td><strong>{{ $cliente->nombre_empresa }}</strong></td>
                    <td>{{ $cliente->rif }}</td>
                    <td>{{ $cliente->direccion_fiscal ?? '-' }}</td>
                    <td>{{ $cliente->zona ?? '-' }}</td>
                    <td>{{ $cliente->vendedor ? $cliente->vendedor->nombre : 'Sin asignar' }}</td>
                    <td>{{ $cliente->created_at->format('d/m/Y') }}</td>
                    <td>
                        <a href="{{ route('admin.clientes.show', $cliente->id) }}" class="btn btn-sm btn-info btn-icon" title="Ver cliente">
                            <i class="fas fa-eye"></i>
                        </a>
                        <a href="{{ route('admin.clientes.edit', $cliente->id) }}" class="btn btn-sm btn-warning btn-icon" title="Editar">
                            <i class="fas fa-edit"></i>
                        </a>
                    </td>
                </tr>
            @empty
                <tr>
                    <td colspan="7" class="text-center">
                        <i class="fas fa-check-circle"></i> ¡Excelente! Todos los clientes tienen al menos un documento.
                    </td>
                </tr>
            @endforelse
        </tbody>
    </table>
</div>
@endsection

