@extends('layouts.app')

@section('title', 'Reporte: Documentos Próximos a Vencer')

@section('content')
<div class="page-header">
    <h1 class="page-title">
        <i class="fas fa-clock"></i> Documentos Próximos a Vencer
    </h1>
    <div class="header-actions">
        <a href="{{ route('admin.reportes.index') }}" class="btn btn-secondary">
            <i class="fas fa-arrow-left"></i> Volver
        </a>
    </div>
</div>

<div class="card" style="margin-bottom: 2rem;">
    <div class="card-body">
        <form method="GET" action="{{ route('admin.reportes.documentos-proximos-vencer') }}" class="inline-form">
            <div class="form-group" style="display: flex; gap: 1rem; align-items: flex-end;">
                <div style="flex: 1;">
                    <label class="form-label" for="meses">Meses de anticipación</label>
                    <select name="meses" id="meses" class="form-select">
                        <option value="3" {{ request('meses') == '3' ? 'selected' : '' }}>3 meses</option>
                        <option value="6" {{ request('meses') == '6' || !request('meses') ? 'selected' : '' }}>6 meses</option>
                        <option value="12" {{ request('meses') == '12' ? 'selected' : '' }}>12 meses</option>
                    </select>
                </div>
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-filter"></i> Filtrar
                </button>
            </div>
        </form>
    </div>
</div>

<div class="alert alert-info">
    <i class="fas fa-info-circle"></i> 
    Total de documentos próximos a vencer: <strong>{{ $total }}</strong>
</div>

@foreach($porMes as $mes => $documentos)
    @php
        $fecha = \Carbon\Carbon::createFromFormat('Y-m', $mes);
    @endphp
    
    <div class="card" style="margin-bottom: 2rem;">
        <div class="card-header">
            <h3>
                <i class="fas fa-calendar"></i> {{ $fecha->format('F Y') }}
                <span class="badge badge-warning">{{ $documentos->count() }} documentos</span>
            </h3>
        </div>
        <div class="card-body">
            <div class="table-container">
                <table class="data-table">
                    <thead>
                        <tr>
                            <th>Cliente</th>
                            <th>RIF</th>
                            <th>Tipo Documento</th>
                            <th>Archivo</th>
                            <th>Fecha Vencimiento</th>
                            <th>Días Restantes</th>
                            <th>Vendedor</th>
                            <th>Acciones</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($documentos as $doc)
                            <tr>
                                <td>{{ $doc->cliente->nombre_empresa }}</td>
                                <td>{{ $doc->cliente->rif }}</td>
                                <td>{{ $doc->tipoDocumento->nombre }}</td>
                                <td>{{ $doc->nombre_archivo }}</td>
                                <td>{{ $doc->fecha_vencimiento->format('d/m/Y') }}</td>
                                <td>
                                    <span class="badge badge-warning">
                                        {{ now()->diffInDays($doc->fecha_vencimiento, false) }} días
                                    </span>
                                </td>
                                <td>{{ $doc->cliente->vendedor ? $doc->cliente->vendedor->nombre : 'Sin asignar' }}</td>
                                <td>
                                    <a href="{{ route('admin.clientes.show', $doc->cliente->id) }}" class="btn btn-sm btn-info btn-icon" title="Ver cliente">
                                        <i class="fas fa-eye"></i>
                                    </a>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
@endforeach

@if($porMes->isEmpty())
<div class="alert alert-warning">
    <i class="fas fa-exclamation-triangle"></i> No hay documentos próximos a vencer para mostrar.
</div>
@endif
@endsection

