@extends('layouts.app')

@section('title', 'Reporte: Documentos Vencidos por Vendedor')

@section('content')
<div class="page-header">
    <h1 class="page-title">
        <i class="fas fa-exclamation-triangle"></i> Documentos Vencidos por Vendedor
    </h1>
    <div class="header-actions">
        <a href="{{ route('admin.reportes.index') }}" class="btn btn-secondary">
            <i class="fas fa-arrow-left"></i> Volver
        </a>
    </div>
</div>

<!-- Filtro -->
<div class="card" style="margin-bottom: 2rem;">
    <div class="card-body">
        <form method="GET" action="{{ route('admin.reportes.documentos-vencidos-vendedor') }}" class="inline-form">
            <div class="form-group" style="display: flex; gap: 1rem; align-items: flex-end;">
                <div style="flex: 1;">
                    <label class="form-label" for="vendedor_id">Vendedor</label>
                    <select name="vendedor_id" id="vendedor_id" class="form-select">
                        <option value="">Todos los vendedores</option>
                        @foreach($vendedores as $vendedor)
                            <option value="{{ $vendedor->id }}" {{ request('vendedor_id') == $vendedor->id ? 'selected' : '' }}>
                                {{ $vendedor->nombre }}
                            </option>
                        @endforeach
                    </select>
                </div>
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-filter"></i> Filtrar
                </button>
            </div>
        </form>
    </div>
</div>

<div class="alert alert-info">
    <i class="fas fa-info-circle"></i> 
    Total de documentos vencidos: <strong>{{ $total }}</strong>
</div>

@foreach($porVendedor as $vendedorId => $documentos)
    @php
        $vendedor = $documentos->first()->cliente->vendedor ?? null;
        $vendedorNombre = $vendedor ? $vendedor->nombre : 'Sin Vendedor';
    @endphp
    
    <div class="card" style="margin-bottom: 2rem;">
        <div class="card-header">
            <h3>
                <i class="fas fa-user"></i> {{ $vendedorNombre }}
                <span class="badge badge-danger">{{ $documentos->count() }} documentos vencidos</span>
            </h3>
        </div>
        <div class="card-body">
            <div class="table-container">
                <table class="data-table">
                    <thead>
                        <tr>
                            <th>Cliente</th>
                            <th>RIF</th>
                            <th>Tipo Documento</th>
                            <th>Archivo</th>
                            <th>Fecha Vencimiento</th>
                            <th>Días Vencido</th>
                            <th>Acciones</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($documentos as $doc)
                            <tr>
                                <td>{{ $doc->cliente->nombre_empresa }}</td>
                                <td>{{ $doc->cliente->rif }}</td>
                                <td>{{ $doc->tipoDocumento->nombre }}</td>
                                <td>{{ $doc->nombre_archivo }}</td>
                                <td>{{ $doc->fecha_vencimiento->format('d/m/Y') }}</td>
                                <td>
                                    <span class="badge badge-danger">
                                        {{ now()->diffInDays($doc->fecha_vencimiento) }} días
                                    </span>
                                </td>
                                <td>
                                    <a href="{{ route('admin.clientes.show', $doc->cliente->id) }}" class="btn btn-sm btn-info btn-icon" title="Ver cliente">
                                        <i class="fas fa-eye"></i>
                                    </a>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
@endforeach

@if($porVendedor->isEmpty())
<div class="alert alert-warning">
    <i class="fas fa-exclamation-triangle"></i> No hay documentos vencidos para mostrar.
</div>
@endif
@endsection

