@extends('layouts.app')

@section('title', 'Solicitudes')

@section('content')
<div class="page-header">
    <h1 class="page-title">Gestión de Solicitudes</h1>
    <div class="pagination-controls" style="display: flex; align-items: center; gap: 1rem;">
        <label for="per_page" style="display: flex; align-items: center; gap: 0.5rem;">
            <i class="fas fa-list"></i> Por página:
            <select name="per_page" id="per_page" class="form-select" style="width: auto;" onchange="window.location.href = '{{ route('admin.solicitudes.index') }}?per_page=' + this.value">
                <option value="10" {{ request('per_page') == '10' ? 'selected' : '' }}>10</option>
                <option value="20" {{ request('per_page') == '20' || !request('per_page') ? 'selected' : '' }}>20</option>
                <option value="50" {{ request('per_page') == '50' ? 'selected' : '' }}>50</option>
                <option value="100" {{ request('per_page') == '100' ? 'selected' : '' }}>100</option>
            </select>
        </label>
    </div>
</div>

<div class="tabs">
    <button class="tab-btn active" onclick="showTab('creacion')">Solicitudes de Creación</button>
    <button class="tab-btn" onclick="showTab('edicion')">Solicitudes de Edición</button>
</div>

<div id="tab-creacion" class="tab-content">
    <h2>Solicitudes de Creación de Clientes</h2>
    <div class="table-container">
        <table class="data-table">
            <thead>
                <tr>
                    <th>Vendedor</th>
                    <th>Nombre Empresa</th>
                    <th>RIF</th>
                    <th>Fecha Solicitud</th>
                    <th>Estatus</th>
                    <th>Acciones</th>
                </tr>
            </thead>
            <tbody>
                @forelse($solicitudesCreacion as $solicitud)
                    <tr>
                        <td>{{ $solicitud->vendedor->nombre }}</td>
                        <td>{{ $solicitud->nombre_empresa }}</td>
                        <td>{{ $solicitud->rif }}</td>
                        <td>{{ $solicitud->fecha_solicitud->format('d/m/Y') }}</td>
                        <td>
                            <span class="badge status-{{ strtolower($solicitud->estatus) }}">
                                {{ $solicitud->estatus }}
                            </span>
                        </td>
                        <td class="actions">
                            @if($solicitud->estatus === 'Pendiente')
                                <form action="{{ route('admin.solicitudes-creacion.aprobar', $solicitud->id) }}" 
                                      method="POST" class="inline-form">
                                    @csrf
                                    <button type="submit" class="btn btn-sm btn-success" title="Aprobar solicitud">
                                        <i class="fas fa-check-circle"></i> Aprobar
                                    </button>
                                </form>
                                <button type="button" class="btn btn-sm btn-danger" 
                                        onclick="rechazarSolicitud({{ $solicitud->id }}, 'creacion')"
                                        title="Rechazar solicitud">
                                    <i class="fas fa-times-circle"></i> Rechazar
                                </button>
                            @endif
                        </td>
                    </tr>
                @empty
                    <tr><td colspan="6" class="text-center">No hay solicitudes de creación.</td></tr>
                @endforelse
            </tbody>
        </table>
        {{ $solicitudesCreacion->links() }}
    </div>
</div>

<div id="tab-edicion" class="tab-content" style="display:none;">
    <h2>Solicitudes de Edición de Clientes</h2>
    <div class="table-container">
        <table class="data-table">
            <thead>
                <tr>
                    <th>Cliente</th>
                    <th>Vendedor</th>
                    <th>Fecha Solicitud</th>
                    <th>Estatus</th>
                    <th>Acciones</th>
                </tr>
            </thead>
            <tbody>
                @forelse($solicitudesEdicion as $solicitud)
                    <tr>
                        <td>{{ $solicitud->cliente->nombre_empresa }}</td>
                        <td>{{ $solicitud->vendedor->nombre }}</td>
                        <td>{{ $solicitud->fecha_solicitud->format('d/m/Y') }}</td>
                        <td>
                            <span class="badge status-{{ strtolower($solicitud->estatus) }}">
                                {{ $solicitud->estatus }}
                            </span>
                        </td>
                        <td class="actions">
                            @if($solicitud->estatus === 'Pendiente')
                                <form action="{{ route('admin.solicitudes-edicion.aprobar', $solicitud->id) }}" 
                                      method="POST" class="inline-form">
                                    @csrf
                                    <button type="submit" class="btn btn-sm btn-success" title="Aprobar solicitud">
                                        <i class="fas fa-check-circle"></i> Aprobar
                                    </button>
                                </form>
                                <button type="button" class="btn btn-sm btn-danger"
                                        onclick="rechazarSolicitud({{ $solicitud->id }}, 'edicion')"
                                        title="Rechazar solicitud">
                                    <i class="fas fa-times-circle"></i> Rechazar
                                </button>
                            @endif
                        </td>
                    </tr>
                @empty
                    <tr><td colspan="5" class="text-center">No hay solicitudes de edición.</td></tr>
                @endforelse
            </tbody>
        </table>
        {{ $solicitudesEdicion->links() }}
    </div>
</div>

<script>
function showTab(tab) {
    document.querySelectorAll('.tab-content').forEach(t => t.style.display = 'none');
    document.querySelectorAll('.tab-btn').forEach(b => b.classList.remove('active'));
    document.getElementById('tab-' + tab).style.display = 'block';
    event.target.classList.add('active');
}

function rechazarSolicitud(id, tipo) {
    const observaciones = prompt('Ingresa las observaciones para el rechazo:');
    if (observaciones) {
        const form = document.createElement('form');
        form.method = 'POST';
        form.action = `/admin/solicitudes-${tipo}/${id}/rechazar`;
        form.innerHTML = `
            @csrf
            <input type="hidden" name="observaciones" value="${observaciones}">
        `;
        document.body.appendChild(form);
        form.submit();
    }
}
</script>
@endsection

