@extends('layouts.app')

@section('title', 'Editar Tipo de Documento')

@section('content')
<div class="page-header">
    <h1 class="page-title">Editar Tipo de Documento</h1>
    <a href="{{ route('admin.tipos-documento.index') }}" class="btn btn-secondary">
        <i class="fas fa-arrow-left"></i> Volver
    </a>
</div>

<div class="card">
    <div class="card-header">
        <h3>Información del Tipo de Documento</h3>
    </div>
    <div class="card-body">
        <form action="{{ route('admin.tipos-documento.update', $tiposDocumento->id) }}" method="POST">
            @csrf
            @method('PUT')
            
            <div class="form-group">
                <label class="form-label" for="nombre">Nombre *</label>
                <input type="text" name="nombre" id="nombre" class="form-control" 
                       value="{{ old('nombre', $tiposDocumento->nombre) }}" required maxlength="255" autofocus>
                @error('nombre')
                    <span class="text-danger">{{ $message }}</span>
                @enderror
            </div>

            <div class="form-group">
                <label class="form-label" for="descripcion">Descripción</label>
                <textarea name="descripcion" id="descripcion" class="form-control" rows="3">{{ old('descripcion', $tiposDocumento->descripcion) }}</textarea>
                @error('descripcion')
                    <span class="text-danger">{{ $message }}</span>
                @enderror
            </div>

            <div class="form-group">
                <label class="form-check-label">
                    <input type="checkbox" name="activo" value="1" {{ old('activo', $tiposDocumento->activo) ? 'checked' : '' }}>
                    Activo
                </label>
                <small class="form-text text-muted">Los tipos de documento inactivos no aparecerán en los formularios de carga.</small>
            </div>

            <div class="form-group">
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-save"></i> Actualizar Tipo de Documento
                </button>
                <a href="{{ route('admin.tipos-documento.index') }}" class="btn btn-secondary">
                    Cancelar
                </a>
            </div>
        </form>
    </div>
</div>
@endsection

