@extends('layouts.app')

@section('title', 'Editar Usuario')

@section('content')
<div class="page-header">
    <h1 class="page-title">Editar Usuario: {{ $usuario->nombre }}</h1>
    <a href="{{ route('admin.usuarios.index') }}" class="btn btn-secondary">
        <i class="fas fa-arrow-left"></i> Volver
    </a>
</div>

<form action="{{ route('admin.usuarios.update', $usuario->id) }}" method="POST" class="form-container">
    @csrf @method('PUT')
    
    <div class="form-group">
        <label for="nombre">Nombre *</label>
        <input type="text" name="nombre" id="nombre" 
               class="form-control" value="{{ old('nombre', $usuario->nombre) }}" required>
    </div>
    
    <div class="form-group">
        <label for="email">Email *</label>
        <input type="email" name="email" id="email" 
               class="form-control" value="{{ old('email', $usuario->email) }}" required>
    </div>
    
    <div class="form-group">
        <label for="password">Nueva Contraseña (dejar vacío para mantener la actual)</label>
        <input type="password" name="password" id="password" 
               class="form-control" minlength="8">
    </div>
    
    <div class="form-group">
        <label for="password_confirmation">Confirmar Nueva Contraseña</label>
        <input type="password" name="password_confirmation" id="password_confirmation" 
               class="form-control" minlength="8">
    </div>
    
    <div class="form-group">
        <label for="rol_id">Rol *</label>
        <select name="rol_id" id="rol_id" class="form-control" required>
            <option value="">Seleccionar...</option>
            @foreach($roles as $rol)
                <option value="{{ $rol->id }}" 
                        {{ old('rol_id', $usuario->rol_id) == $rol->id ? 'selected' : '' }}>
                    {{ $rol->nombre_rol }}
                </option>
            @endforeach
        </select>
    </div>
    
    <div class="form-group">
        <label>
            <input type="checkbox" name="activo" value="1" 
                   {{ old('activo', $usuario->activo) ? 'checked' : '' }}>
            Usuario Activo
        </label>
    </div>
    
    <div class="form-actions">
        <button type="submit" class="btn btn-primary">
            <i class="fas fa-save"></i> Actualizar Usuario
        </button>
        <a href="{{ route('admin.usuarios.index') }}" class="btn btn-secondary">Cancelar</a>
    </div>
</form>
@endsection

