@extends('layouts.app')

@section('title', 'Usuarios')

@section('content')
<div class="page-header">
    <h1 class="page-title">Gestión de Usuarios</h1>
    <a href="{{ route('admin.usuarios.create') }}" class="btn btn-primary">
        <i class="fas fa-plus"></i> Nuevo Usuario
    </a>
</div>

<div class="pagination-controls" style="margin-bottom: 1rem; display: flex; justify-content: flex-end; align-items: center; gap: 1rem;">
    <label for="per_page" style="display: flex; align-items: center; gap: 0.5rem;">
        <i class="fas fa-list"></i> Por página:
        <select name="per_page" id="per_page" class="form-select" style="width: auto;" onchange="window.location.href = '{{ route('admin.usuarios.index') }}?per_page=' + this.value">
            <option value="10" {{ request('per_page') == '10' ? 'selected' : '' }}>10</option>
            <option value="20" {{ request('per_page') == '20' || !request('per_page') ? 'selected' : '' }}>20</option>
            <option value="50" {{ request('per_page') == '50' ? 'selected' : '' }}>50</option>
            <option value="100" {{ request('per_page') == '100' ? 'selected' : '' }}>100</option>
        </select>
    </label>
</div>

<div class="table-container">
    <table class="data-table">
        <thead>
            <tr>
                <th>Nombre</th>
                <th>Email</th>
                <th>Rol</th>
                <th>Estado</th>
                <th>Acciones</th>
            </tr>
        </thead>
        <tbody>
            @forelse($usuarios as $usuario)
                <tr>
                    <td>{{ $usuario->nombre }}</td>
                    <td>{{ $usuario->email }}</td>
                    <td>{{ $usuario->rol->nombre_rol }}</td>
                    <td>
                        <span class="badge {{ $usuario->activo ? 'badge-success' : 'badge-danger' }}">
                            {{ $usuario->activo ? 'Activo' : 'Inactivo' }}
                        </span>
                    </td>
                    <td class="actions">
                        <a href="{{ route('admin.usuarios.edit', $usuario->id) }}" class="btn btn-sm btn-warning btn-icon" title="Editar">
                            <i class="fas fa-edit"></i>
                        </a>
                        @if($usuario->id !== auth()->id())
                        <form action="{{ route('admin.usuarios.destroy', $usuario->id) }}" 
                              method="POST" class="inline-form delete-form">
                            @csrf @method('DELETE')
                            <button type="submit" class="btn btn-sm btn-danger btn-icon" title="Eliminar" data-tooltip="Eliminar usuario">
                                <i class="fas fa-trash-alt"></i>
                            </button>
                        </form>
                        @endif
                    </td>
                </tr>
            @empty
                <tr><td colspan="5" class="text-center">No hay usuarios registrados.</td></tr>
            @endforelse
        </tbody>
    </table>
    {{ $usuarios->links() }}
</div>
@endsection

