<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>@yield('title', 'Gestión Documental')</title>
    
    <!-- PWA Meta Tags -->
    <meta name="application-name" content="Gestión Documental DGYM">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="default">
    <meta name="apple-mobile-web-app-title" content="DGYM">
    <meta name="description" content="Sistema de gestión documental para clientes">
    <meta name="theme-color" content="#0d6efd">
    
    <!-- PWA Manifest -->
    <link rel="manifest" href="{{ asset('manifest.json') }}">
    
    <!-- Apple Touch Icons -->
    <link rel="apple-touch-icon" href="{{ asset('vendedor/assets/icons/icon-192x192.png') }}">
    
    <!-- Favicon -->
    <link rel="icon" type="image/png" sizes="32x32" href="{{ asset('vendedor/assets/icons/icon-32x32.png') }}">
    
    <!-- Styles -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" integrity="sha512-iecdLmaskl7CVkqkXNQ/ZH/XLlvWZOJyj7Yy7tcenmpD1ypASozpmT/E0iPtmFIB46ZmdtAc9eNBvH0H/ZpiBw==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link rel="stylesheet" href="{{ asset('assets/css/style.css') }}">
    
    <!-- Service Worker Registration -->
    <script>
        if ('serviceWorker' in navigator) {
            window.addEventListener('load', function() {
                // Desregistrar cualquier Service Worker existente primero
                navigator.serviceWorker.getRegistrations().then(function(registrations) {
                    for(let registration of registrations) {
                        registration.unregister();
                    }
                });
            });
        }
    </script>
    
    @stack('styles')
</head>
<body>
    <div class="app-container">
        <!-- Header -->
        <header class="app-header">
            <div class="header-content">
                <div class="header-left">
                    <button class="menu-toggle" id="menuToggle" aria-label="Toggle menu">
                        <i class="fas fa-bars"></i>
                    </button>
                    <h1 class="app-title">
                        <i class="fas fa-folder-open"></i> <span>Gestión Documental DGYM</span>
                    </h1>
                </div>
                <nav class="header-nav" id="headerNav">
                    <div class="nav-main">
                        <!-- Navegación Principal -->
                        <a href="{{ route('admin.dashboard') }}" class="nav-link {{ request()->routeIs('admin.dashboard') ? 'active' : '' }}" data-tooltip="Dashboard (g+d)">
                            <i class="fas fa-home"></i> <span>Dashboard</span>
                        </a>
                        <a href="{{ route('admin.clientes.index') }}" class="nav-link {{ request()->routeIs('admin.clientes.*') ? 'active' : '' }}" data-tooltip="Clientes (g+c)">
                            <i class="fas fa-users"></i> <span>Clientes</span>
                        </a>
                        <a href="{{ route('admin.usuarios.index') }}" class="nav-link {{ request()->routeIs('admin.usuarios.*') ? 'active' : '' }}" data-tooltip="Usuarios (g+u)">
                            <i class="fas fa-user-shield"></i> <span>Usuarios</span>
                        </a>
                        <a href="{{ route('admin.solicitudes.index') }}" class="nav-link {{ request()->routeIs('admin.solicitudes.*') ? 'active' : '' }}" data-tooltip="Solicitudes (g+s)">
                            <i class="fas fa-clipboard-list"></i> <span>Solicitudes</span>
                        </a>
                        
                        <!-- Menú Desplegable: Gestión -->
                        <div class="nav-dropdown">
                            <a href="#" class="nav-link nav-dropdown-toggle {{ request()->routeIs('admin.tipos-documento.*') || request()->routeIs('admin.notificaciones.index') ? 'active' : '' }}">
                                <i class="fas fa-cog"></i> <span>Gestión</span> <i class="fas fa-chevron-down nav-chevron"></i>
                            </a>
                            <div class="nav-dropdown-menu">
                                <a href="{{ route('admin.tipos-documento.index') }}" class="nav-dropdown-item {{ request()->routeIs('admin.tipos-documento.*') ? 'active' : '' }}">
                                    <i class="fas fa-file-alt"></i> Tipos de Documento
                                </a>
                                <a href="{{ route('admin.notificaciones.index') }}" class="nav-dropdown-item {{ request()->routeIs('admin.notificaciones.index') ? 'active' : '' }}">
                                    <i class="fas fa-bell"></i> Notificaciones
                                </a>
                            </div>
                        </div>
                        
                        <!-- Menú Desplegable: Reportes y Análisis -->
                        <div class="nav-dropdown">
                            <a href="#" class="nav-link nav-dropdown-toggle {{ request()->routeIs('admin.reportes.*') || request()->routeIs('admin.auditoria.*') ? 'active' : '' }}">
                                <i class="fas fa-chart-bar"></i> <span>Reportes</span> <i class="fas fa-chevron-down nav-chevron"></i>
                            </a>
                            <div class="nav-dropdown-menu">
                                <a href="{{ route('admin.reportes.index') }}" class="nav-dropdown-item {{ request()->routeIs('admin.reportes.index') ? 'active' : '' }}">
                                    <i class="fas fa-chart-pie"></i> Ver Reportes
                                </a>
                                <a href="{{ route('admin.auditoria.index') }}" class="nav-dropdown-item {{ request()->routeIs('admin.auditoria.*') ? 'active' : '' }}">
                                    <i class="fas fa-shield-alt"></i> Auditoría
                                </a>
                            </div>
                        </div>
                        
                        <!-- Menú Desplegable: Sistema -->
                        <div class="nav-dropdown">
                            <a href="#" class="nav-link nav-dropdown-toggle {{ request()->routeIs('admin.backup.*') || request()->routeIs('admin.configuracion.*') ? 'active' : '' }}">
                                <i class="fas fa-server"></i> <span>Sistema</span> <i class="fas fa-chevron-down nav-chevron"></i>
                            </a>
                            <div class="nav-dropdown-menu">
                                <a href="{{ route('admin.backup.index') }}" class="nav-dropdown-item {{ request()->routeIs('admin.backup.*') ? 'active' : '' }}">
                                    <i class="fas fa-database"></i> Backup
                                </a>
                                <a href="{{ route('admin.configuracion.index') }}" class="nav-dropdown-item {{ request()->routeIs('admin.configuracion.*') ? 'active' : '' }}">
                                    <i class="fas fa-cog"></i> Configuración
                                </a>
                            </div>
                        </div>
                    </div>
                    <div class="nav-actions">
                        <div class="notifications-dropdown">
                            <a href="#" class="nav-link notifications-toggle" id="notificationsToggle" title="Notificaciones">
                                <i class="fas fa-bell"></i>
                                <span class="notification-badge" id="notificationBadge" style="display: none;">0</span>
                            </a>
                            <div class="notifications-menu" id="notificationsMenu">
                                <div class="notifications-header">
                                    <h4>Notificaciones</h4>
                                    <button type="button" class="btn-mark-all-read" id="markAllRead">
                                        <i class="fas fa-check-double"></i> Marcar todas como leídas
                                    </button>
                                </div>
                                <div class="notifications-list" id="notificationsList">
                                    <div class="notification-loading">
                                        <i class="fas fa-spinner fa-spin"></i> Cargando...
                                    </div>
                                </div>
                                <div class="notifications-footer">
                                    <a href="{{ route('admin.notificaciones.index') }}">Ver todas las notificaciones</a>
                                </div>
                            </div>
                        </div>
                        <div class="user-menu">
                            <div class="user-info">
                                <i class="fas fa-user-circle"></i>
                                <span>{{ auth()->user()->nombre }}</span>
                            </div>
                        </div>
                        <form action="{{ route('logout') }}" method="POST" class="inline-form" id="logoutForm">
                            @csrf
                            <button type="submit" class="nav-link btn-logout" title="Cerrar sesión" id="logoutBtn">
                                <i class="fas fa-sign-out-alt"></i> <span>Salir</span>
                            </button>
                        </form>
                    </div>
                </nav>
            </div>
        </header>

        <!-- Main Content -->
        <main class="app-main">
            @if(session('success'))
                <div class="alert alert-success alert-animated" id="successAlert">
                    <div class="alert-content">
                        <i class="fas fa-check-circle"></i>
                        <span>{{ session('success') }}</span>
                    </div>
                    <button type="button" class="alert-close" onclick="this.parentElement.remove()">
                        <i class="fas fa-times"></i>
                    </button>
                </div>
            @endif

            @if(session('error'))
                <div class="alert alert-error alert-animated" id="errorAlert">
                    <div class="alert-content">
                        <i class="fas fa-exclamation-circle"></i>
                        <span>{{ session('error') }}</span>
                    </div>
                    <button type="button" class="alert-close" onclick="this.parentElement.remove()">
                        <i class="fas fa-times"></i>
                    </button>
                </div>
            @endif

            @if($errors->any())
                <div class="alert alert-error alert-animated" id="errorsAlert">
                    <div class="alert-content">
                        <i class="fas fa-exclamation-triangle"></i>
                        <div>
                            <strong>Errores encontrados:</strong>
                            <ul style="margin: 0.5rem 0 0 1.5rem;">
                                @foreach($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    </div>
                    <button type="button" class="alert-close" onclick="this.parentElement.remove()">
                        <i class="fas fa-times"></i>
                    </button>
                </div>
            @endif

            @yield('content')
        </main>

        <!-- Footer -->
        <footer class="app-footer">
            <p>&copy; {{ date('Y') }} Gestión Documental DGYM. Todos los derechos reservados.</p>
        </footer>
    </div>

    <!-- Scripts -->
    <script src="{{ asset('assets/js/mani.js') }}"></script>
    <script src="{{ asset('assets/js/modals.js') }}"></script>
    <script src="{{ asset('assets/js/keyboard-shortcuts.js') }}"></script>
    <script>
        // Menú móvil y dropdowns
        (function() {
            const menuToggle = document.getElementById('menuToggle');
            const headerNav = document.getElementById('headerNav');
            
            // Toggle menú móvil
            if (menuToggle && headerNav) {
                menuToggle.addEventListener('click', function() {
                    headerNav.classList.toggle('active');
                    const icon = menuToggle.querySelector('i');
                    if (headerNav.classList.contains('active')) {
                        icon.classList.remove('fa-bars');
                        icon.classList.add('fa-times');
                    } else {
                        icon.classList.remove('fa-times');
                        icon.classList.add('fa-bars');
                    }
                });
                
                // Cerrar menú al hacer click en un enlace
                headerNav.querySelectorAll('.nav-link:not(.nav-dropdown-toggle)').forEach(link => {
                    link.addEventListener('click', function() {
                        if (window.innerWidth <= 768) {
                            headerNav.classList.remove('active');
                            const icon = menuToggle.querySelector('i');
                            icon.classList.remove('fa-times');
                            icon.classList.add('fa-bars');
                        }
                    });
                });
            }
            
            // Dropdowns del menú
            document.querySelectorAll('.nav-dropdown-toggle').forEach(toggle => {
                toggle.addEventListener('click', function(e) {
                    e.preventDefault();
                    const dropdown = this.closest('.nav-dropdown');
                    const isActive = dropdown.classList.contains('active');
                    
                    // Cerrar otros dropdowns
                    document.querySelectorAll('.nav-dropdown').forEach(d => {
                        if (d !== dropdown) {
                            d.classList.remove('active');
                        }
                    });
                    
                    // Toggle este dropdown
                    if (isActive) {
                        dropdown.classList.remove('active');
                    } else {
                        dropdown.classList.add('active');
                    }
                });
            });
            
            // Cerrar dropdowns al hacer click fuera
            document.addEventListener('click', function(e) {
                if (!e.target.closest('.nav-dropdown')) {
                    document.querySelectorAll('.nav-dropdown').forEach(d => {
                        d.classList.remove('active');
                    });
                }
            });
        })();
        
        // Asegurar que el botón de logout funcione correctamente
        const logoutBtn = document.getElementById('logoutBtn');
        const logoutForm = document.getElementById('logoutForm');
        
        if (logoutBtn && logoutForm) {
            logoutBtn.addEventListener('click', function(e) {
                // Prevenir doble envío
                if (logoutForm.dataset.submitting === 'true') {
                    e.preventDefault();
                    return false;
                }
                
                logoutForm.dataset.submitting = 'true';
                logoutBtn.disabled = true;
                const originalHTML = logoutBtn.innerHTML;
                logoutBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> <span>Saliendo...</span>';
                
                // Forzar envío del formulario
                logoutForm.submit();
            });
        }
    </script>
    <script>
        // Notificaciones en tiempo real
        (function() {
            const badge = document.getElementById('notificationBadge');
            const menu = document.getElementById('notificationsMenu');
            const toggle = document.getElementById('notificationsToggle');
            const list = document.getElementById('notificationsList');
            const markAllRead = document.getElementById('markAllRead');

            function cargarNotificaciones() {
                fetch('{{ route("admin.notificaciones.no-leidas") }}', {
                    headers: {
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content,
                        'Accept': 'application/json'
                    }
                })
                .then(response => response.json())
                .then(data => {
                    if (data.total > 0) {
                        badge.textContent = data.total > 99 ? '99+' : data.total;
                        badge.style.display = 'inline-block';
                    } else {
                        badge.style.display = 'none';
                    }

                    if (data.notificaciones.length === 0) {
                        list.innerHTML = '<div class="notification-empty"><i class="fas fa-bell-slash"></i><p>No hay notificaciones nuevas</p></div>';
                        return;
                    }

                    list.innerHTML = data.notificaciones.map(notif => `
                        <div class="notification-item ${notif.tipo}" data-id="${notif.id}">
                            <div class="notification-icon">
                                <i class="fas fa-${notif.tipo === 'alerta' ? 'exclamation-triangle' : notif.tipo === 'importante' ? 'exclamation-circle' : 'info-circle'}"></i>
                            </div>
                            <div class="notification-content">
                                <div class="notification-title">${notif.titulo}</div>
                                <div class="notification-message">${notif.mensaje}</div>
                                <div class="notification-time">${notif.fecha}</div>
                            </div>
                            <button class="notification-mark-read" onclick="marcarLeida(${notif.id})">
                                <i class="fas fa-check"></i>
                            </button>
                        </div>
                    `).join('');
                })
                .catch(error => console.error('Error cargando notificaciones:', error));
            }

            function marcarLeida(id) {
                fetch(`/admin/notificaciones/${id}/marcar-leida`, {
                    method: 'POST',
                    headers: {
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content,
                        'Accept': 'application/json'
                    }
                })
                .then(() => {
                    cargarNotificaciones();
                });
            }

            window.marcarLeida = marcarLeida;

            if (markAllRead) {
                markAllRead.addEventListener('click', function() {
                    fetch('{{ route("admin.notificaciones.marcar-todas-leidas") }}', {
                        method: 'POST',
                        headers: {
                            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content,
                            'Accept': 'application/json'
                        }
                    })
                    .then(() => {
                        cargarNotificaciones();
                    });
                });
            }

            if (toggle) {
                toggle.addEventListener('click', function(e) {
                    e.preventDefault();
                    menu.classList.toggle('active');
                    if (menu.classList.contains('active')) {
                        cargarNotificaciones();
                    }
                });

                // Cerrar al hacer click fuera
                document.addEventListener('click', function(e) {
                    if (!toggle.contains(e.target) && !menu.contains(e.target)) {
                        menu.classList.remove('active');
                    }
                });
            }

            // Cargar notificaciones al iniciar
            cargarNotificaciones();

            // Actualizar cada 30 segundos
            setInterval(cargarNotificaciones, 30000);
        })();
    </script>
    <script>
        // Auto-ocultar alertas después de 5 segundos
        document.addEventListener('DOMContentLoaded', function() {
            const alerts = document.querySelectorAll('.alert-animated');
            alerts.forEach(alert => {
                setTimeout(() => {
                    if (alert && !alert.matches(':hover')) {
                        alert.style.transition = 'all 0.4s ease';
                        alert.style.opacity = '0';
                        alert.style.transform = 'translateY(-10px)';
                        setTimeout(() => {
                            if (alert && alert.parentElement) {
                                alert.remove();
                            }
                        }, 400);
                    }
                }, 5000);
            });
        });
    </script>
    @stack('scripts')
</body>
</html>

