@extends('layouts.vendedor')

@section('title', 'Mis Clientes')

@section('content')
<div class="page-header">
    <h1 class="page-title">Mis Clientes</h1>
    @if($view === 'todos')
        <a href="{{ route('vendedor.solicitar-cliente') }}" class="btn btn-primary">
            <i class="fas fa-plus"></i> Solicitar Cliente
        </a>
    @endif
</div>

@if($view === 'proximos')
    <div class="alert alert-warning">
        <i class="fas fa-exclamation-triangle"></i> Clientes con documentos próximos a vencer
    </div>
@endif

<div class="client-list">
    @forelse($clientes as $cliente)
        @php $estatus = $cliente->calcularEstatus(); @endphp
        @if($view !== 'proximos' || $estatus['texto'] === 'ALERTA')
        <div class="client-card-wrapper">
            <a href="{{ route('vendedor.clientes.show', $cliente->id) }}" 
               class="client-card status-{{ $estatus['clase'] }}">
                <div class="client-card-status-icon">
                    <i class="{{ $estatus['icono'] }}"></i>
                </div>
                <div class="client-card-info">
                    <h4>{{ $cliente->nombre_empresa }}</h4>
                    <p>RIF: {{ $cliente->rif }}</p>
                </div>
                <div class="client-card-arrow">
                    <i class="fas fa-chevron-right"></i>
                </div>
            </a>
        </div>
        @endif
    @empty
        <div class="card-empty">
            <i class="fas fa-folder-open"></i>
            <p>No hay clientes que mostrar en esta vista.</p>
        </div>
    @endforelse
</div>
@endsection
