@extends('layouts.vendedor')

@section('title', 'Ficha de Cliente: ' . $cliente->nombre_empresa)

@section('content')
<div class="cliente-ficha-vendedor">
    <div class="ficha-header">
        <h1>{{ $cliente->nombre_empresa }}</h1>
        <span class="badge status-{{ $estatus['clase'] }}">
            <i class="{{ $estatus['icono'] }}"></i> {{ $estatus['texto'] }}
        </span>
    </div>

    <div class="ficha-info">
        <p><strong>RIF:</strong> {{ $cliente->rif }}</p>
        <p><strong>Dirección Fiscal:</strong> {{ $cliente->direccion_fiscal ?? '-' }}</p>
        <p><strong>Zona:</strong> {{ $cliente->zona ?? '-' }}</p>
    </div>

    <div class="upload-section">
        <h2>Subir Documento</h2>
        <form action="{{ route('vendedor.documentos.store') }}" method="POST" enctype="multipart/form-data" 
              id="upload-form" class="upload-form">
            @csrf
            <input type="hidden" name="cliente_id" value="{{ $cliente->id }}">
            
            <div class="form-group">
                <label for="tipo_documento_id">Tipo de Documento *</label>
                <select name="tipo_documento_id" id="tipo_documento_id" class="form-control" required>
                    <option value="">Seleccionar...</option>
                    @foreach($tiposDocumento as $tipo)
                        <option value="{{ $tipo->id }}">{{ $tipo->nombre }}</option>
                    @endforeach
                </select>
            </div>
            
            <div class="form-group">
                <label for="archivo">Archivo *</label>
                <input type="file" name="archivo" id="archivo" class="form-control" 
                       accept=".pdf,.jpg,.jpeg,.png" required>
            </div>
            
            <div class="form-group">
                <label for="fecha_vencimiento">Fecha de Vencimiento</label>
                <input type="date" name="fecha_vencimiento" id="fecha_vencimiento" class="form-control">
            </div>
            
            <div class="form-group">
                <label for="observaciones">Observaciones</label>
                <textarea name="observaciones" id="observaciones" class="form-control" rows="2"></textarea>
            </div>
            
            <button type="submit" class="btn btn-primary">
                <i class="fas fa-upload"></i> Subir Documento
            </button>
        </form>
    </div>

    <div class="documentos-section">
        <h2>Documentos del Cliente</h2>
        <div class="documentos-list">
            @forelse($cliente->documentos as $documento)
                <div class="documento-item">
                    <div class="documento-info">
                        <i class="fas fa-file-alt"></i>
                        <div>
                            <strong>{{ $documento->tipoDocumento->nombre }}</strong>
                            <small>{{ $documento->nombre_archivo }}</small>
                            @if($documento->fecha_vencimiento)
                                <small>
                                    Vence: {{ $documento->fecha_vencimiento->format('d/m/Y') }}
                                    @if($documento->esta_vencido)
                                        <span class="badge badge-danger">Vencido</span>
                                    @elseif($documento->proximo_a_vencer)
                                        <span class="badge badge-warning">Próximo a vencer</span>
                                    @endif
                                </small>
                            @endif
                        </div>
                    </div>
                    <div class="documento-actions">
                        <a href="{{ route('vendedor.documentos.download', $documento->id) }}" 
                           class="btn btn-sm btn-info" target="_blank">
                            <i class="fas fa-download"></i>
                        </a>
                        <form action="{{ route('vendedor.documentos.destroy', $documento->id) }}" 
                              method="POST" class="inline-form"
                              onsubmit="return confirm('¿Eliminar este documento?');">
                            @csrf @method('DELETE')
                            <button type="submit" class="btn btn-sm btn-danger">
                                <i class="fas fa-trash"></i>
                            </button>
                        </form>
                    </div>
                </div>
            @empty
                <p class="text-muted">No hay documentos registrados.</p>
            @endforelse
        </div>
    </div>

    @if($cliente->historialCambios->isNotEmpty())
    <div class="historial-section">
        <h2>Historial de Cambios</h2>
        <div class="historial-list">
            @foreach($cliente->historialCambios->sortByDesc('created_at') as $historial)
                <div class="historial-item">
                    <div class="historial-date">{{ $historial->created_at->format('d/m/Y H:i') }}</div>
                    <div class="historial-user">{{ $historial->usuario->nombre }}</div>
                    <div class="historial-action">{{ $historial->accion_realizada }}</div>
                </div>
            @endforeach
        </div>
    </div>
    @endif
</div>

@push('scripts')
<script src="{{ asset('vendedor/assets/js/offline-document-manager.js') }}"></script>
@endpush
@endsection

