@extends('layouts.vendedor')

@section('title', 'Dashboard - Vendedor')

@section('content')
<div class="dashboard-grid-vendedor">
    <div class="stat-card-vendedor">
        <h4>Total de Clientes</h4>
        <p><i class="fas fa-users"></i> {{ $totalClientes }}</p>
    </div>
    <div class="stat-card-vendedor">
        <h4>Próximos a Vencer</h4>
        <p><i class="fas fa-exclamation-triangle"></i> {{ $clientesAlerta }}</p>
    </div>
    <div class="stat-card-vendedor">
        <h4>Sin Documentos</h4>
        <p><i class="fas fa-folder-minus"></i> {{ $clientesSinDocs }}</p>
    </div>
</div>

<nav class="app-menu">
    <a href="{{ route('vendedor.dashboard', ['view' => 'todos']) }}" 
       class="menu-item {{ $view === 'todos' ? 'active' : '' }}">Todos los Clientes</a>
    <a href="{{ route('vendedor.dashboard', ['view' => 'proximos']) }}" 
       class="menu-item {{ $view === 'proximos' ? 'active' : '' }}">Próximos a Vencer</a>
    <a href="{{ route('vendedor.dashboard', ['view' => 'solicitudes']) }}" 
       class="menu-item {{ $view === 'solicitudes' ? 'active' : '' }}">Estado de Solicitudes</a>
</nav>

<div class="content-area">
    @if($view === 'todos' || $view === 'proximos')
        <div class="header-section-grid">
            <h1 class="content-title">
                <i class="fas fa-users"></i> 
                {{ $view === 'proximos' ? 'Clientes Próximos a Vencer' : 'Mis Clientes' }}
            </h1>
            @if($view === 'todos')
                <a href="{{ route('vendedor.solicitar-cliente') }}" class="btn">
                    <i class="fas fa-plus"></i> Solicitar Cliente
                </a>
            @endif
        </div>

        <div class="client-list">
            @forelse($listaClientes as $cliente)
                @php $estatus = $cliente->calcularEstatus(); @endphp
                @if($view !== 'proximos' || $estatus['texto'] === 'ALERTA')
                <div class="client-card-wrapper">
                    <a href="{{ route('vendedor.clientes.show', $cliente->id) }}" 
                       class="client-card status-{{ $estatus['clase'] }}">
                        <div class="client-card-status-icon"><i class="{{ $estatus['icono'] }}"></i></div>
                        <div class="client-card-info">
                            <h4>{{ $cliente->nombre_empresa }}</h4>
                            <p>RIF: {{ $cliente->rif }}</p>
                        </div>
                        <div class="client-card-arrow"><i class="fas fa-chevron-right"></i></div>
                    </a>
                    @if($view === 'proximos' && isset($clientesConAlertaDocs[$cliente->id]))
                        <ul class="document-list-inline">
                            @foreach($clientesConAlertaDocs[$cliente->id] as $doc)
                                <li>
                                    <i class="fas fa-file-alt"></i> 
                                    {{ $doc->tipoDocumento->nombre }} 
                                    (Vence: {{ $doc->fecha_vencimiento->format('d/m/Y') }})
                                </li>
                            @endforeach
                        </ul>
                    @endif
                </div>
                @endif
            @empty
                <div class="card-empty">
                    <i class="fas fa-folder-open"></i>
                    <p>No hay clientes que mostrar en esta vista.</p>
                </div>
            @endforelse
        </div>
        
        @if($view === 'todos' && $listaClientes->isNotEmpty())
            <div class="text-center" style="margin-top: 20px;">
                <a href="{{ route('vendedor.clientes.index', ['view' => 'proximos']) }}" class="btn btn-secondary">
                    Ver Próximos a Vencer
                </a>
            </div>
        @endif
    @elseif($view === 'solicitudes')
        <h1 class="content-title"><i class="fas fa-history"></i> Estado de Mis Solicitudes</h1>
        <div class="solicitudes-list">
            @forelse($solicitudes as $solicitud)
                <div class="solicitud-item">
                    <div class="solicitud-info">
                        <strong>{{ $solicitud->nombre_empresa }}</strong>
                        <small>
                            RIF: {{ $solicitud->rif }} | 
                            Solicitado: {{ $solicitud->fecha_solicitud->format('d/m/Y') }}
                        </small>
                    </div>
                    <span class="badge status-{{ strtolower($solicitud->estatus) }}">
                        {{ $solicitud->estatus }}
                    </span>
                </div>
            @empty
                <div class="card-empty"><p>No tienes solicitudes.</p></div>
            @endforelse
        </div>
    @endif
</div>
@endsection

