<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\PushNotificationController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

// Rutas de Push Notifications (PWA)
Route::prefix('push')->group(function () {
    Route::get('/public-key', [PushNotificationController::class, 'getPublicKey']);
    Route::post('/subscribe', [PushNotificationController::class, 'subscribe'])->middleware('auth');
    Route::post('/unsubscribe', [PushNotificationController::class, 'unsubscribe'])->middleware('auth');
    Route::post('/verify-subscription', [PushNotificationController::class, 'verifySubscription'])->middleware('auth');
});

