<?php

use App\Http\Controllers\Admin\DashboardController as AdminDashboardController;
use App\Http\Controllers\Admin\ClienteController as AdminClienteController;
use App\Http\Controllers\Vendedor\DashboardController as VendedorDashboardController;
use App\Http\Controllers\AuthController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

// Rutas de autenticación
Route::get('/login', [AuthController::class, 'showLoginForm'])->name('login');
Route::post('/login', [AuthController::class, 'login']);
Route::post('/logout', [AuthController::class, 'logout'])->name('logout');

// Rutas administrativas (requieren autenticación y rol Administrador)
Route::middleware(['auth', 'role:Administrador'])->prefix('admin')->name('admin.')->group(function () {
    Route::get('/dashboard', [AdminDashboardController::class, 'index'])->name('dashboard');
    
    // Clientes
    Route::resource('clientes', AdminClienteController::class);
    
    // Documentos
    Route::post('/documentos', [\App\Http\Controllers\Admin\DocumentoController::class, 'store'])->name('documentos.store');
    Route::delete('/documentos/{documento}', [\App\Http\Controllers\Admin\DocumentoController::class, 'destroy'])->name('documentos.destroy');
    Route::get('/documentos/{documento}/download', [\App\Http\Controllers\Admin\DocumentoController::class, 'download'])->name('documentos.download');
    
    // Usuarios
    Route::resource('usuarios', \App\Http\Controllers\Admin\UsuarioController::class);
    
    // Solicitudes
    Route::get('/solicitudes', [\App\Http\Controllers\Admin\SolicitudController::class, 'index'])->name('solicitudes.index');
    Route::post('/solicitudes-creacion/{solicitud}/aprobar', [\App\Http\Controllers\Admin\SolicitudController::class, 'aprobarCreacion'])->name('solicitudes-creacion.aprobar');
    Route::post('/solicitudes-creacion/{solicitud}/rechazar', [\App\Http\Controllers\Admin\SolicitudController::class, 'rechazarCreacion'])->name('solicitudes-creacion.rechazar');
    Route::post('/solicitudes-edicion/{solicitud}/aprobar', [\App\Http\Controllers\Admin\SolicitudController::class, 'aprobarEdicion'])->name('solicitudes-edicion.aprobar');
    Route::post('/solicitudes-edicion/{solicitud}/rechazar', [\App\Http\Controllers\Admin\SolicitudController::class, 'rechazarEdicion'])->name('solicitudes-edicion.rechazar');
    
    // Notificaciones
    Route::get('/notificaciones', [\App\Http\Controllers\Admin\NotificacionController::class, 'index'])->name('notificaciones.index');
    Route::post('/notificaciones', [\App\Http\Controllers\Admin\NotificacionController::class, 'store'])->name('notificaciones.store');
    Route::post('/notificaciones/enviar-todos', [\App\Http\Controllers\Admin\NotificacionController::class, 'enviarATodos'])->name('notificaciones.enviar-todos');
    Route::post('/notificaciones/{notificacion}/marcar-leida', [\App\Http\Controllers\Admin\NotificacionController::class, 'marcarLeida'])->name('notificaciones.marcar-leida');
    Route::post('/notificaciones/marcar-todas-leidas', [\App\Http\Controllers\Admin\NotificacionController::class, 'marcarTodasLeidas'])->name('notificaciones.marcar-todas-leidas');
    Route::get('/notificaciones/no-leidas', [\App\Http\Controllers\Admin\NotificacionController::class, 'obtenerNoLeidas'])->name('notificaciones.no-leidas');
    
    // Tipos de Documento
    Route::resource('tipos-documento', \App\Http\Controllers\Admin\TipoDocumentoController::class);
    
    // Exportación
    Route::get('/exportar/clientes', [\App\Http\Controllers\Admin\ExportController::class, 'exportarClientes'])->name('exportar.clientes');
    Route::get('/exportar/documentos-vencidos', [\App\Http\Controllers\Admin\ExportController::class, 'exportarDocumentosVencidos'])->name('exportar.documentos-vencidos');
    Route::get('/exportar/documentos-proximos', [\App\Http\Controllers\Admin\ExportController::class, 'exportarDocumentosProximosAVencer'])->name('exportar.documentos-proximos');
    Route::get('/exportar/documentos-cliente/{cliente}', [\App\Http\Controllers\Admin\ExportController::class, 'exportarDocumentosCliente'])->name('exportar.documentos-cliente');
    
    // Configuración
    Route::get('/configuracion', [\App\Http\Controllers\Admin\ConfiguracionController::class, 'index'])->name('configuracion.index');
    Route::put('/configuracion', [\App\Http\Controllers\Admin\ConfiguracionController::class, 'update'])->name('configuracion.update');
    
    // Reportes
    Route::get('/reportes', [\App\Http\Controllers\Admin\ReporteController::class, 'index'])->name('reportes.index');
    Route::get('/reportes/documentos-vencidos-vendedor', [\App\Http\Controllers\Admin\ReporteController::class, 'documentosVencidosPorVendedor'])->name('reportes.documentos-vencidos-vendedor');
    Route::get('/reportes/documentos-proximos-vencer', [\App\Http\Controllers\Admin\ReporteController::class, 'documentosProximosAVencer'])->name('reportes.documentos-proximos-vencer');
    Route::get('/reportes/actividad-vendedores', [\App\Http\Controllers\Admin\ReporteController::class, 'actividadVendedores'])->name('reportes.actividad-vendedores');
    Route::get('/reportes/clientes-sin-documentos', [\App\Http\Controllers\Admin\ReporteController::class, 'clientesSinDocumentos'])->name('reportes.clientes-sin-documentos');
    
    // Auditoría
    Route::get('/auditoria', [\App\Http\Controllers\Admin\AuditoriaController::class, 'index'])->name('auditoria.index');
    
    // Backup
    Route::get('/backup', [\App\Http\Controllers\Admin\BackupController::class, 'index'])->name('backup.index');
    Route::post('/backup/crear', [\App\Http\Controllers\Admin\BackupController::class, 'crearBackup'])->name('backup.crear');
    Route::get('/backup/descargar/{filename}', [\App\Http\Controllers\Admin\BackupController::class, 'descargarBackup'])->name('backup.descargar');
    Route::delete('/backup/eliminar/{filename}', [\App\Http\Controllers\Admin\BackupController::class, 'eliminarBackup'])->name('backup.eliminar');
});

// Rutas vendedor (requieren autenticación y rol Vendedor)
Route::middleware(['auth', 'vendedor'])->prefix('vendedor')->name('vendedor.')->group(function () {
    Route::get('/dashboard', [VendedorDashboardController::class, 'index'])->name('dashboard');
    
    // Clientes del vendedor
    Route::get('/clientes', [\App\Http\Controllers\Vendedor\ClienteController::class, 'index'])->name('clientes.index');
    Route::get('/clientes/{cliente}', [\App\Http\Controllers\Vendedor\ClienteController::class, 'show'])->name('clientes.show');
    
    // Documentos
    Route::post('/documentos', [\App\Http\Controllers\Vendedor\DocumentoController::class, 'store'])->name('documentos.store');
    Route::delete('/documentos/{documento}', [\App\Http\Controllers\Vendedor\DocumentoController::class, 'destroy'])->name('documentos.destroy');
    Route::get('/documentos/{documento}/download', [\App\Http\Controllers\Vendedor\DocumentoController::class, 'download'])->name('documentos.download');
    
    // Solicitudes
    Route::get('/solicitar-cliente', [\App\Http\Controllers\Vendedor\SolicitudController::class, 'create'])->name('solicitar-cliente');
    Route::post('/solicitar-cliente', [\App\Http\Controllers\Vendedor\SolicitudController::class, 'store'])->name('solicitar-cliente.store');
    Route::get('/clientes/{cliente}/solicitar-edicion', [\App\Http\Controllers\Vendedor\SolicitudController::class, 'solicitarEdicion'])->name('clientes.solicitar-edicion');
    Route::post('/clientes/{cliente}/solicitar-edicion', [\App\Http\Controllers\Vendedor\SolicitudController::class, 'storeEdicion'])->name('clientes.solicitar-edicion.store');
});

// Login específico para vendedores
Route::get('/vendedor/login', [AuthController::class, 'showVendedorLoginForm'])->name('vendedor.login');
Route::post('/vendedor/login', [AuthController::class, 'vendedorLogin']);

// Ruta raíz - redirige según autenticación
Route::get('/', function () {
    if (auth()->check()) {
        $user = auth()->user();
        if ($user->isAdmin()) {
            return redirect()->route('admin.dashboard');
        } elseif ($user->isVendedor()) {
            return redirect()->route('vendedor.dashboard');
        }
    }
    return redirect()->route('login');
});
