<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no">
    <title>Login - Gestión Documental</title>
    
    <!-- PWA Meta Tags -->
    <meta name="application-name" content="Gestión Documental DGYM">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="default">
    <meta name="apple-mobile-web-app-title" content="DGYM">
    <meta name="description" content="Sistema de gestión documental para clientes">
    <meta name="theme-color" content="#0d6efd">
    
    <!-- PWA Manifest -->
    <link rel="manifest" href="<?php echo e(asset('manifest.json')); ?>">
    
    <!-- Apple Touch Icons -->
    <link rel="apple-touch-icon" href="<?php echo e(asset('vendedor/assets/icons/icon-192x192.png')); ?>">
    
    <!-- Favicon -->
    <link rel="icon" type="image/png" sizes="32x32" href="<?php echo e(asset('vendedor/assets/icons/icon-32x32.png')); ?>">
    
    <!-- Styles -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" integrity="sha512-iecdLmaskl7CVkqkXNQ/ZH/XLlvWZOJyj7Yy7tcenmpD1ypASozpmT/E0iPtmFIB46ZmdtAc9eNBvH0H/ZpiBw==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/style.css')); ?>">
    
    <!-- Service Worker Registration -->
    <script>
        if ('serviceWorker' in navigator) {
            window.addEventListener('load', function() {
                // Desregistrar cualquier Service Worker existente primero
                navigator.serviceWorker.getRegistrations().then(function(registrations) {
                    for(let registration of registrations) {
                        registration.unregister();
                    }
                });
            });
        }
    </script>
</head>
<body class="glass-login-body">
    <div class="glass-login-container">
        <h2 class="glass-login-title">CONTROL CLIENTES DGYM</h2>
        
        <?php if($errors->any()): ?>
            <div class="error-alert">
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <p><?php echo e($error); ?></p>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        <?php endif; ?>

        <form action="<?php echo e(route('login')); ?>" method="POST">
            <?php echo csrf_field(); ?>
            
            <div class="glass-form-group">
                <i class="fas fa-user glass-input-icon"></i>
                <input type="email" name="email" class="glass-input" placeholder="Usuario" value="<?php echo e(old('email')); ?>" required autofocus>
            </div>
            
            <div class="glass-form-group">
                <i class="fas fa-lock glass-input-icon"></i>
                <input type="password" name="password" class="glass-input" placeholder="Contraseña" required>
            </div>
            
            <div class="glass-form-group">
                <label>
                    <input type="checkbox" name="remember">
                    Recordarme
                </label>
            </div>
            
            <button type="submit" class="glass-btn">LOGIN</button>
        </form>
    </div>
</body>
</html>

<?php /**PATH C:\laragon\www\DOCUMENTOS\resources\views/auth/login.blade.php ENDPATH**/ ?>